/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.twosigma.beakerx.BeakerCodeCell;
import com.twosigma.beakerx.jvm.serialization.BeakerCodeCellList;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import java.io.IOException;
import java.util.ArrayList;

public class BeakerCodeCellListDeserializer
extends JsonDeserializer<BeakerCodeCellList> {
    private final Provider<BeakerObjectConverter> objectSerializerProvider;

    @Inject
    public BeakerCodeCellListDeserializer(Provider<BeakerObjectConverter> osp) {
        this.objectSerializerProvider = osp;
    }

    public BeakerCodeCellList deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        ArrayList<BeakerCodeCell> l = new ArrayList<BeakerCodeCell>();
        if (node.isArray()) {
            for (JsonNode o : node) {
                Object obj = ((BeakerObjectConverter)this.objectSerializerProvider.get()).deserialize(o, mapper);
                if (!(obj instanceof BeakerCodeCell)) continue;
                l.add((BeakerCodeCell)obj);
            }
        }
        BeakerCodeCellList r = new BeakerCodeCellList();
        r.theList = l;
        return r;
    }
}

