/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.autocomplete;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

public class ClasspathScanner {
    protected Map<String, List<String>> packages = new HashMap<String, List<String>>();

    public ClasspathScanner() {
        String classpath = System.getProperty("java.class.path");
        this.scanClasses(classpath);
    }

    public ClasspathScanner(String classpath) {
        this.scanClasses(classpath);
    }

    public Set<String> getPackages() {
        return this.packages.keySet();
    }

    public List<String> getClasses(String p) {
        if (this.packages.containsKey(p)) {
            return this.packages.get(p);
        }
        return null;
    }

    private void scanClasses(String classpath) {
        String[] paths = classpath.split(System.getProperty("path.separator"));
        String javaHome = System.getProperty("java.home");
        File file = new File(javaHome + File.separator + "lib");
        if (file.exists()) {
            this.findClasses(file, file, true);
        }
        for (String path : paths) {
            file = new File(path);
            if (!file.exists()) continue;
            this.findClasses(file, file, true);
        }
    }

    private boolean findClasses(File root, File file, boolean includeJars) {
        if (file != null && file.isDirectory()) {
            File[] lf = file.listFiles();
            if (lf != null) {
                for (File child : lf) {
                    if (this.findClasses(root, child, includeJars)) continue;
                    return false;
                }
            }
        } else if (file.getName().toLowerCase().endsWith(".jar") && includeJars) {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jar != null) {
                try {
                    String cp;
                    Manifest mf = jar.getManifest();
                    if (mf != null && StringUtils.isNotEmpty((CharSequence)(cp = mf.getMainAttributes().getValue("Class-Path")))) {
                        for (String fn : cp.split(" ")) {
                            File child = new File(file.getParent() + System.getProperty("file.separator") + fn);
                            if (child.getAbsolutePath().equals(jar.getName()) || !child.exists() || this.findClasses(root, child, includeJars)) continue;
                            return false;
                        }
                    }
                }
                catch (IOException mf) {
                    // empty catch block
                }
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String cname;
                    int pIndex;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    int extIndex = name.lastIndexOf(".class");
                    if (extIndex <= 0 || name.contains("$") || (pIndex = (cname = name.substring(0, extIndex).replace("/", ".")).lastIndexOf(46)) <= 0) continue;
                    String pname = cname.substring(0, pIndex);
                    cname = cname.substring(pIndex + 1);
                    if (!this.packages.containsKey(pname)) {
                        this.packages.put(pname, new ArrayList());
                    }
                    this.packages.get(pname).add(cname);
                }
            }
        } else if (file.getName().toLowerCase().endsWith(".class")) {
            int pIndex;
            String cname = this.createClassName(root, file);
            if (!cname.contains("$") && (pIndex = cname.lastIndexOf(46)) > 0) {
                String pname = cname.substring(0, pIndex + 1);
                cname = cname.substring(pIndex);
                if (!this.packages.containsKey(pname)) {
                    this.packages.put(pname, new ArrayList());
                }
                this.packages.get(pname).add(cname);
            }
        } else {
            this.examineFile(root, file);
        }
        return true;
    }

    protected void examineFile(File root, File file) {
    }

    private String createClassName(File root, File file) {
        StringBuffer sb = new StringBuffer();
        String fileName = file.getName();
        sb.append(fileName.substring(0, fileName.lastIndexOf(".class")));
        for (file = file.getParentFile(); file != null && !file.equals(root); file = file.getParentFile()) {
            sb.insert(0, '.').insert(0, file.getName());
        }
        return sb.toString();
    }
}

