/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.twincoders.twinpush.sdk.logging.Ln;

public class PushPermissionRequest {
    private Callback callback = null;
    private final ComponentActivity activity;
    private final ActivityResultLauncher<String> requestPermissionLauncher;

    @RequiresApi(api=33)
    public static String getPushPermission() {
        return "android.permission.POST_NOTIFICATIONS";
    }

    public static PushPermissionRequest registerForResult(ComponentActivity activity) {
        return new PushPermissionRequest(activity);
    }

    private PushPermissionRequest(ComponentActivity activity) {
        this.activity = activity;
        this.requestPermissionLauncher = activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), this::onPermissionResult);
    }

    private void onPermissionResult(boolean granted) {
        if (this.callback != null) {
            this.callback.onResult(granted);
        }
    }

    public void launch(Callback callback) {
        this.callback = callback;
        if (Build.VERSION.SDK_INT >= 33) {
            Ln.d("Android SDK version >= 33, required to request POST_NOTIFICATIONS permission", new Object[0]);
            if (PushPermissionRequest.isPermissionGranted((Context)this.activity)) {
                Ln.d("Permission for POST_NOTIFICATIONS granted!", new Object[0]);
                callback.onResult(true);
            } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)PushPermissionRequest.getPushPermission())) {
                Ln.d("Permission for POST_NOTIFICATIONS has already been denied", new Object[0]);
                callback.onResult(false);
            } else {
                Ln.d("Requesting POST_NOTIFICATIONS permission", new Object[0]);
                this.requestPermissionLauncher.launch((Object)PushPermissionRequest.getPushPermission());
            }
        } else {
            Ln.d("Android SDK version < 33, not required to request POST_NOTIFICATIONS permission", new Object[0]);
            callback.onResult(true);
        }
    }

    public static boolean isPermissionGranted(Context context) {
        if (Build.VERSION.SDK_INT >= 33) {
            return ContextCompat.checkSelfPermission((Context)context, (String)PushPermissionRequest.getPushPermission()) == 0;
        }
        return true;
    }

    public static interface Callback {
        public void onResult(boolean var1);
    }
}

