/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.util;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.util.List;

public class LastLocationFinder {
    protected static String SINGLE_LOCATION_UPDATE_ACTION = "com.twincoders.twinpush.sdk.SINGLE_LOCATION_UPDATE_ACTION";
    protected PendingIntent singleUpatePI;
    protected LocationListener locationListener;
    protected LocationManager locationManager;
    protected Context context;
    protected Criteria criteria;
    protected BroadcastReceiver singleUpdateReceiver;

    public LastLocationFinder(Context context) {
        this.context = context;
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.criteria = new Criteria();
        this.criteria.setAccuracy(1);
        Intent updateIntent = new Intent(SINGLE_LOCATION_UPDATE_ACTION);
        int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        this.singleUpatePI = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)updateIntent, (int)flags);
    }

    public Location getLastBestLocation(int minDistance, long minTime) {
        Location bestResult = null;
        float bestAccuracy = Float.MAX_VALUE;
        long bestTime = Long.MIN_VALUE;
        List matchingProviders = this.locationManager.getAllProviders();
        for (String provider : matchingProviders) {
            boolean missingPermission;
            boolean bl = missingPermission = ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0;
            if (missingPermission) {
                Ln.e("Missing required ACCESS_FINE_LOCATION permission to update location", new Object[0]);
                return null;
            }
            Location location = this.locationManager.getLastKnownLocation(provider);
            if (location == null) continue;
            float accuracy = location.getAccuracy();
            long time = location.getTime();
            if (time > minTime && accuracy < bestAccuracy) {
                bestResult = location;
                bestAccuracy = accuracy;
                bestTime = time;
                continue;
            }
            if (time >= minTime || bestAccuracy != Float.MAX_VALUE || time <= bestTime) continue;
            bestResult = location;
            bestTime = time;
        }
        if (this.locationListener != null && (bestTime < minTime || bestAccuracy > (float)minDistance)) {
            IntentFilter locIntentFilter = new IntentFilter(SINGLE_LOCATION_UPDATE_ACTION);
            this.singleUpdateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    context.unregisterReceiver(LastLocationFinder.this.singleUpdateReceiver);
                    String key = "location";
                    Location location = (Location)intent.getExtras().get(key);
                    if (LastLocationFinder.this.locationListener != null && location != null) {
                        LastLocationFinder.this.locationListener.onLocationChanged(location);
                    }
                    LastLocationFinder.this.locationManager.removeUpdates(LastLocationFinder.this.singleUpatePI);
                }
            };
            ContextCompat.registerReceiver((Context)this.context, (BroadcastReceiver)this.singleUpdateReceiver, (IntentFilter)locIntentFilter, (int)4);
            try {
                this.locationManager.requestSingleUpdate(this.criteria, this.singleUpatePI);
            }
            catch (Exception ex) {
                Ln.e("Error while trying to update location: %s", ex.getLocalizedMessage());
            }
        }
        return bestResult;
    }

    public void setChangedLocationListener(LocationListener l) {
        this.locationListener = l;
    }

    public void cancel() {
        this.locationManager.removeUpdates(this.singleUpatePI);
        if (this.singleUpdateReceiver != null) {
            this.context.unregisterReceiver(this.singleUpdateReceiver);
            this.singleUpdateReceiver = null;
        }
    }
}

