/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.services;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.twincoders.twinpush.sdk.R;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.logging.Strings;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import com.twincoders.twinpush.sdk.services.SilentPushReceiver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultNotificationService {
    public static final String EXTRA_NOTIFICATION_TITLE = "title";
    public static final String EXTRA_NOTIFICATION_MESSAGE = "message";
    public static final String EXTRA_NOTIFICATION_ID = "tp_id";
    public static final String EXTRA_NOTIFICATION_CUSTOM = "custom";
    public static final String EXTRA_NOTIFICATION_TAGS = "tags";
    public static final String EXTRA_NOTIFICATION_RICH_URL = "tp_rich_url";

    public void displayNotification(@NonNull Context context, @NonNull PushNotification notification, @NonNull PendingIntent contentIntend) {
        String channelId;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            Ln.e("Notifications permission NOT granted. Notification not displayed.", new Object[0]);
            return;
        }
        String title = notification.getTitle();
        if (title == null || title.trim().isEmpty()) {
            int stringId = context.getApplicationInfo().labelRes;
            title = context.getString(stringId);
        }
        if (Strings.isEmpty(channelId = notification.getCustomProperties().get("tp_channel_id"))) {
            channelId = context.getString(R.string.twinPush_default_channel_id);
        }
        if (channelId != null) {
            Notification push = new NotificationCompat.Builder(context, channelId).setContentTitle((CharSequence)title).setContentText((CharSequence)notification.getMessage()).setTicker((CharSequence)notification.getMessage()).setSmallIcon(R.drawable.ic_tp_notification).setDefaults(7).setContentIntent(contentIntend).setAutoCancel(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage())).build();
            NotificationManagerCompat.from((Context)context).notify(notification.getId().hashCode(), push);
        } else {
            Ln.e("ERROR: Notification not displayed. Notification channel can not be null", new Object[0]);
        }
    }

    public PendingIntent getContentIntent(Context context, PushNotification notification) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        intent.setAction("con.twincoders.twinpush.sdk.PUSH_NOTIFICATION_OPENED");
        intent.setFlags(0x24000000);
        intent.putExtra("notification", (Serializable)notification);
        int flags = Build.VERSION.SDK_INT >= 23 ? 0x14000000 : 0x10000000;
        return PendingIntent.getActivity((Context)context, (int)notification.getId().hashCode(), (Intent)intent, (int)flags);
    }

    public void onSilentPushReceived(Context context, PushNotification notification) {
        SilentPushReceiver silentPushReceiver = TwinPushSDK.getInstance(context).getSilentReceiver();
        if (silentPushReceiver != null) {
            Ln.d("Silent push arrived. Notifying %s...", silentPushReceiver.getClass().getName());
            silentPushReceiver.onSilentPushReceived(context, notification);
        } else {
            Ln.w("Silent push arrived, but no receiver set.", new Object[0]);
        }
    }

    public PushNotification getNotification(Map<String, String> data) {
        String notificationId = data.get(EXTRA_NOTIFICATION_ID);
        String title = data.get(EXTRA_NOTIFICATION_TITLE);
        String message = data.get(EXTRA_NOTIFICATION_MESSAGE);
        String richURL = data.get(EXTRA_NOTIFICATION_RICH_URL);
        Date date = new Date();
        Map<String, String> customProperties = this.getCustomPropertiesMap(data.get(EXTRA_NOTIFICATION_CUSTOM));
        List<String> tagArray = this.getTagArray(data.get(EXTRA_NOTIFICATION_TAGS));
        PushNotification notification = new PushNotification();
        notification.setId(notificationId);
        notification.setTitle(title);
        notification.setMessage(message);
        notification.setDate(date);
        notification.setRichURL(richURL);
        notification.setCustomProperties(customProperties);
        notification.setTags(tagArray);
        return notification;
    }

    public Map<String, String> getCustomPropertiesMap(String custom) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        try {
            if (custom != null) {
                JSONObject json = new JSONObject(custom);
                Iterator iterator = json.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        String value = (String)json.get(key);
                        propertiesMap.put(key, value);
                    }
                    catch (JSONException e) {
                        Ln.e(e, (Object)"Could not find property %s on Custom properties JSON", key);
                    }
                }
            }
        }
        catch (Exception e) {
            Ln.e(e, (Object)"Error while trying to parse JSON object", new Object[0]);
        }
        return propertiesMap;
    }

    public List<String> getTagArray(String jsonString) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            if (jsonString != null) {
                JSONArray jsonArray = new JSONArray(jsonString);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    result.add(jsonArray.getString(i));
                }
            }
        }
        catch (Exception e) {
            Ln.e(e, (Object)"Error while trying to parse JSON object", new Object[0]);
        }
        return result;
    }
}

