/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.notifications;

import com.twincoders.twinpush.sdk.communications.DefaultRequestParam;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.entities.InboxNotification;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetInboxRequest
extends TwinPushRequest {
    private static final String SEGMENT = "inbox";
    private static final String PAGE_KEY = "page";
    private static final String RESULTS_PER_PAGE_KEY = "per_page";
    private static final String TAGS_KEY = "tags";
    private static final String NO_TAGS_KEY = "no_tags";
    private static final String RESPONSE_TOTAL_PAGES_KEY = "total_pages";
    private static final String RESPONSE_NOTIF_ARRAY_KEY = "objects";
    private Listener listener;

    public GetInboxRequest(String applicationId, String deviceId, List<String> tags, List<String> noTags, int page, int resultsPerPage, Listener listener) {
        super(applicationId, deviceId);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.GET;
        this.addSegmentParam(SEGMENT);
        if (tags != null) {
            this.addParam(DefaultRequestParam.arrayParam(TAGS_KEY, tags));
        }
        if (noTags != null) {
            this.addParam(DefaultRequestParam.arrayParam(NO_TAGS_KEY, noTags));
        }
        this.addParam(PAGE_KEY, String.valueOf(page + 1));
        this.addParam(RESULTS_PER_PAGE_KEY, String.valueOf(resultsPerPage));
    }

    @Override
    protected void onSuccess(JSONObject response) {
        int totalPages = 0;
        ArrayList<InboxNotification> items = new ArrayList<InboxNotification>();
        try {
            if (response.has(RESPONSE_TOTAL_PAGES_KEY)) {
                totalPages = response.getInt(RESPONSE_TOTAL_PAGES_KEY);
            }
            JSONArray jsonArray = response.getJSONArray(RESPONSE_NOTIF_ARRAY_KEY);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                InboxNotification item = this.parseInboxNotification(json);
                items.add(item);
            }
            this.getListener().onSuccess(items, totalPages);
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to parse inbox notifications from response", new Object[0]);
            this.getListener().onError((Exception)((Object)e));
        }
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess(List<InboxNotification> var1, int var2);
    }
}

