/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import android.content.Context;
import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.communications.DefaultRequestLauncher;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.TwinRequestLauncher;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.communications.requests.forms.ReportFormRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.DeleteInboxNotificationRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetInboxSummaryRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationDetailsRequest;
import com.twincoders.twinpush.sdk.communications.requests.notifications.GetNotificationsRequest;
import com.twincoders.twinpush.sdk.communications.requests.properties.ClearCustomPropertiesRequest;
import com.twincoders.twinpush.sdk.communications.requests.properties.SetCustomPropertyRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.GetBadgeCountRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.RegisterRequest;
import com.twincoders.twinpush.sdk.communications.requests.register.SetBadgeCountRequest;
import com.twincoders.twinpush.sdk.communications.requests.statistics.CloseAppRequest;
import com.twincoders.twinpush.sdk.communications.requests.statistics.OpenAppRequest;
import com.twincoders.twinpush.sdk.communications.requests.statistics.OpenNotificationRequest;
import com.twincoders.twinpush.sdk.communications.requests.statistics.ReceivedNotificationRequest;
import com.twincoders.twinpush.sdk.communications.requests.statistics.ReportStatisticsRequest;
import com.twincoders.twinpush.sdk.entities.InboxNotification;
import com.twincoders.twinpush.sdk.entities.PropertyType;
import com.twincoders.twinpush.sdk.entities.RegistrationInfo;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TwinPushRequestFactory {
    private static TwinPushRequestFactory sharedInstance = null;
    private TwinRequestLauncher requestLauncher;
    private TwinPushSDK twinpush;
    private List<TwinPushRequest> pendingRequests = new ArrayList<TwinPushRequest>();
    private boolean stopRequests = false;

    private String getDeviceId() {
        return this.twinpush.getDeviceId();
    }

    private String getAppId() {
        return this.twinpush.getAppId();
    }

    public static TwinPushRequestFactory getSharedinstance(Context context) {
        if (sharedInstance == null) {
            sharedInstance = new TwinPushRequestFactory(context);
        }
        return sharedInstance;
    }

    private TwinPushRequestFactory(Context context) {
        this.requestLauncher = new DefaultRequestLauncher(context);
        this.twinpush = TwinPushSDK.getInstance(context);
    }

    public TwinPushRequest register(RegistrationInfo registrationInfo, RegisterRequest.Listener listener) {
        RegisterRequest request = new RegisterRequest(this.getAppId(), registrationInfo, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest getNotificationInbox(int page, int resultsPerPage, List<String> tags, List<String> noTags, boolean ignoreNonRichNotifications, GetNotificationsRequest.Listener listener) {
        GetNotificationsRequest request = new GetNotificationsRequest(this.getAppId(), this.getDeviceId(), page, resultsPerPage, tags, noTags, ignoreNonRichNotifications, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest getUserInbox(int page, int resultsPerPage, List<String> tags, List<String> noTags, GetInboxRequest.Listener listener) {
        GetInboxRequest request = new GetInboxRequest(this.getAppId(), this.getDeviceId(), tags, noTags, page, resultsPerPage, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest getUserInboxSummary(GetInboxSummaryRequest.Listener listener) {
        GetInboxSummaryRequest request = new GetInboxSummaryRequest(this.getAppId(), this.getDeviceId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest getNotification(String notificationId, GetNotificationDetailsRequest.Listener listener) {
        GetNotificationDetailsRequest request = new GetNotificationDetailsRequest(this.getAppId(), this.getDeviceId(), notificationId, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest deleteNotification(InboxNotification inboxNotification, TwinRequest.DefaultListener listener) {
        DeleteInboxNotificationRequest request = new DeleteInboxNotificationRequest(this.getAppId(), this.getDeviceId(), inboxNotification.getNotification().getId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest setBadgeCount(int badgeCount, TwinRequest.DefaultListener listener) {
        SetBadgeCountRequest request = new SetBadgeCountRequest(this.getAppId(), this.getDeviceId(), badgeCount, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest getBadgeCount(GetBadgeCountRequest.Listener listener) {
        GetBadgeCountRequest request = new GetBadgeCountRequest(this.getAppId(), this.getDeviceId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest setCustomProperty(String name, PropertyType valueType, Object value, TwinRequest.DefaultListener listener) {
        SetCustomPropertyRequest request = new SetCustomPropertyRequest(this.getAppId(), this.getDeviceId(), name, valueType, value, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest clearCustomProperties(TwinRequest.DefaultListener listener) {
        ClearCustomPropertiesRequest request = new ClearCustomPropertiesRequest(this.getAppId(), this.getDeviceId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest openApp(TwinRequest.DefaultListener listener) {
        OpenAppRequest request = new OpenAppRequest(this.getAppId(), this.getDeviceId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest closeApp(TwinRequest.DefaultListener listener) {
        CloseAppRequest request = new CloseAppRequest(this.getAppId(), this.getDeviceId(), listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest reportStatistics(double latitude, double longitude, TwinRequest.DefaultListener listener) {
        ReportStatisticsRequest request = new ReportStatisticsRequest(this.getAppId(), this.getDeviceId(), latitude, longitude, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest openNotification(String notificationId, TwinRequest.DefaultListener listener) {
        OpenNotificationRequest request = new OpenNotificationRequest(this.getAppId(), this.getDeviceId(), notificationId, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest onReceivedNotification(String notificationId, TwinRequest.DefaultListener listener) {
        ReceivedNotificationRequest request = new ReceivedNotificationRequest(this.getAppId(), this.getDeviceId(), notificationId, listener);
        this.launch(request);
        return request;
    }

    public TwinPushRequest reportForm(String deviceId, String alias, String appToken, String reporterToken, PushNotification notification, Map<String, Object> form, ReportFormRequest.Listener listener) {
        ReportFormRequest request = new ReportFormRequest(deviceId, alias, appToken, reporterToken, notification, form, listener);
        this.launch(request);
        return request;
    }

    private void launch(TwinPushRequest request) {
        if (this.stopRequests) {
            this.pendingRequests.add(request);
        } else {
            if (request.isSequential()) {
                this.stopRequests = true;
                request.addOnRequestFinishListener(new TwinRequest.OnRequestFinishListener(){

                    @Override
                    public void onRequestFinish() {
                        TwinPushRequestFactory.this.stopRequests = false;
                        TwinPushRequestFactory.this.launchNextRequest();
                    }
                });
            } else {
                this.launchNextRequest();
            }
            request.setRequestLauncher(this.requestLauncher);
            request.launch();
        }
    }

    private void launchNextRequest() {
        if (!this.pendingRequests.isEmpty()) {
            TwinPushRequest nextRequest = this.pendingRequests.get(0);
            this.pendingRequests.remove(nextRequest);
            this.launch(nextRequest);
        }
    }
}

