/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import com.twincoders.twinpush.sdk.communications.DefaultRequestParam;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.TwinRequestLauncher;
import com.twincoders.twinpush.sdk.communications.TwinRequestParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class DefaultRequest
implements TwinRequest {
    private List<TwinRequestParam> requestParams = new ArrayList<TwinRequestParam>();
    private TwinRequestLauncher requestLauncher;
    protected TwinRequest.HttpMethod httpMethod = TwinRequest.HttpMethod.POST;
    private List<TwinRequest.OnRequestFinishListener> onRequestFinishListeners = new ArrayList<TwinRequest.OnRequestFinishListener>();
    private Boolean canceled = false;

    DefaultRequest() {
    }

    @Override
    public void addParam(String key, Object value) {
        if (value != null) {
            if (value instanceof List) {
                ArrayList<String> stringList = new ArrayList<String>();
                for (Object item : (List)value) {
                    stringList.add(item.toString());
                }
                this.requestParams.add(DefaultRequestParam.arrayParam(key, stringList));
            } else {
                this.requestParams.add(new DefaultRequestParam(key, value));
            }
        }
    }

    @Override
    public void addParam(TwinRequestParam param) {
        this.requestParams.add(param);
    }

    @Override
    public List<TwinRequestParam> getParams() {
        return this.requestParams;
    }

    @Override
    public void setRequestLauncher(TwinRequestLauncher requestLauncher) {
        this.requestLauncher = requestLauncher;
    }

    @Override
    public Boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void launch() {
        this.canceled = false;
        this.requestLauncher.launchRequest(this);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.requestLauncher != null) {
            this.requestLauncher.cancelRequest(this);
        }
    }

    @Override
    public TwinRequest.HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void onRequestError(Exception exception) {
        if (!this.isCanceled().booleanValue()) {
            this.getListener().onError(exception);
            this.notifyFinishListeners();
        }
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String getBodyContent() {
        return "";
    }

    @Override
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    @Override
    public TwinRequestLauncher getRequestLauncher() {
        return this.requestLauncher;
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public boolean isHttpResponseStatusValid(int httpResponseStatusCode) {
        return false;
    }

    @Override
    public void addOnRequestFinishListener(TwinRequest.OnRequestFinishListener listener) {
        if (!this.onRequestFinishListeners.contains(listener)) {
            this.onRequestFinishListeners.add(listener);
        }
    }

    void notifyFinishListeners() {
        for (TwinRequest.OnRequestFinishListener listener : this.onRequestFinishListeners) {
            listener.onRequestFinish();
        }
    }
}

