/*
 * Decompiled with CFR 0.152.
 */
package com.sharejoys.crashlib.ui;

import com.sharejoys.crashlib.CrashManager;
import com.sharejoys.crashlib.ui.ShowExceptionActivity;
import com.sharejoys.crashlib.util.CrashHelper;

public class ExceptionCaughtAdapter
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public ExceptionCaughtAdapter(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        String crashInfo = CrashHelper.buildCrashInfo(ex);
        CrashHelper.saveCrashLogToLocal(crashInfo);
        if (CrashManager.getInstance().isDebug()) {
            ShowExceptionActivity.showException(crashInfo);
        }
        if (this.uncaughtExceptionHandler != null) {
            this.uncaughtExceptionHandler.uncaughtException(thread, ex);
        }
    }
}

