/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.size;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.size.Size;
import java.util.HashMap;

public class AspectRatio
implements Comparable<AspectRatio> {
    @VisibleForTesting
    static final HashMap<String, AspectRatio> sCache = new HashMap(16);
    private final int mX;
    private final int mY;

    @NonNull
    public static AspectRatio of(@NonNull Size size) {
        return AspectRatio.of(size.getWidth(), size.getHeight());
    }

    @NonNull
    public static AspectRatio of(int x, int y) {
        String key;
        AspectRatio cached;
        int gcd = AspectRatio.gcd(x, y);
        if (gcd > 0) {
            x /= gcd;
        }
        if (gcd > 0) {
            y /= gcd;
        }
        if ((cached = sCache.get(key = x + ":" + y)) == null) {
            cached = new AspectRatio(x, y);
            sCache.put(key, cached);
        }
        return cached;
    }

    @NonNull
    public static AspectRatio parse(@NonNull String string) {
        String[] parts = string.split(":");
        if (parts.length != 2) {
            throw new NumberFormatException("Illegal AspectRatio string. Must be x:y");
        }
        int x = Integer.parseInt(parts[0]);
        int y = Integer.parseInt(parts[1]);
        return AspectRatio.of(x, y);
    }

    private AspectRatio(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public boolean matches(@NonNull Size size) {
        return this.equals(AspectRatio.of(size));
    }

    public boolean matches(@NonNull Size size, float tolerance) {
        return Math.abs(this.toFloat() - AspectRatio.of(size).toFloat()) <= tolerance;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof AspectRatio) {
            return this.toFloat() == ((AspectRatio)o).toFloat();
        }
        return false;
    }

    @NonNull
    public String toString() {
        return this.mX + ":" + this.mY;
    }

    public float toFloat() {
        return (float)this.mX / (float)this.mY;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.toFloat());
    }

    @Override
    public int compareTo(@NonNull AspectRatio another) {
        return Float.compare(this.toFloat(), another.toFloat());
    }

    @NonNull
    public AspectRatio flip() {
        return AspectRatio.of(this.mY, this.mX);
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        return a;
    }
}

