/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.markers;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.PointF;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.markers.AutoFocusMarker;
import com.otaliastudios.cameraview.markers.AutoFocusTrigger;

public class DefaultAutoFocusMarker
implements AutoFocusMarker {
    @VisibleForTesting
    View mContainer;
    @VisibleForTesting
    View mFill;

    @Override
    @Nullable
    public View onAttach(@NonNull Context context, @NonNull ViewGroup container) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.cameraview_layout_focus_marker, container, false);
        this.mContainer = view.findViewById(R.id.focusMarkerContainer);
        this.mFill = view.findViewById(R.id.focusMarkerFill);
        return view;
    }

    @Override
    public void onAutoFocusStart(@NonNull AutoFocusTrigger trigger, @NonNull PointF point) {
        if (trigger == AutoFocusTrigger.METHOD) {
            return;
        }
        this.mContainer.clearAnimation();
        this.mFill.clearAnimation();
        this.mContainer.setScaleX(1.36f);
        this.mContainer.setScaleY(1.36f);
        this.mContainer.setAlpha(1.0f);
        this.mFill.setScaleX(0.0f);
        this.mFill.setScaleY(0.0f);
        this.mFill.setAlpha(1.0f);
        DefaultAutoFocusMarker.animate(this.mContainer, 1.0f, 1.0f, 300L, 0L, null);
        DefaultAutoFocusMarker.animate(this.mFill, 1.0f, 1.0f, 300L, 0L, null);
    }

    @Override
    public void onAutoFocusEnd(@NonNull AutoFocusTrigger trigger, boolean successful, @NonNull PointF point) {
        if (trigger == AutoFocusTrigger.METHOD) {
            return;
        }
        if (successful) {
            DefaultAutoFocusMarker.animate(this.mContainer, 1.0f, 0.0f, 500L, 0L, null);
            DefaultAutoFocusMarker.animate(this.mFill, 1.0f, 0.0f, 500L, 0L, null);
        } else {
            DefaultAutoFocusMarker.animate(this.mFill, 0.0f, 0.0f, 500L, 0L, null);
            DefaultAutoFocusMarker.animate(this.mContainer, 1.36f, 1.0f, 500L, 0L, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    DefaultAutoFocusMarker.animate(DefaultAutoFocusMarker.this.mContainer, 1.36f, 0.0f, 200L, 1000L, null);
                }
            });
        }
    }

    private static void animate(@NonNull View view, float scale, float alpha, long duration, long delay, @Nullable Animator.AnimatorListener listener) {
        view.animate().scaleX(scale).scaleY(scale).alpha(alpha).setDuration(duration).setStartDelay(delay).setListener(listener).start();
    }
}

