/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filter;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.cameraview.filter.TwoParameterFilter;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.opengl.core.Egloo;
import com.otaliastudios.opengl.program.GlProgram;
import com.otaliastudios.opengl.texture.GlFramebuffer;
import com.otaliastudios.opengl.texture.GlTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiFilter
implements Filter,
OneParameterFilter,
TwoParameterFilter {
    @VisibleForTesting
    final List<Filter> filters = new ArrayList<Filter>();
    @VisibleForTesting
    final Map<Filter, State> states = new HashMap<Filter, State>();
    private final Object lock = new Object();
    private Size size = null;
    private float parameter1 = 0.0f;
    private float parameter2 = 0.0f;

    public MultiFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public MultiFilter(@NonNull Collection<Filter> filters) {
        for (Filter filter : filters) {
            this.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(@NonNull Filter filter) {
        if (filter instanceof MultiFilter) {
            MultiFilter multiFilter = (MultiFilter)filter;
            for (Filter multiChild : multiFilter.filters) {
                this.addFilter(multiChild);
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.filters.contains(filter)) {
                this.filters.add(filter);
                this.states.put(filter, new State());
            }
        }
    }

    private void maybeCreateProgram(@NonNull Filter filter, boolean isFirst, boolean isLast) {
        State state = this.states.get(filter);
        if (state.isProgramCreated) {
            return;
        }
        state.isProgramCreated = true;
        String fragmentShader = isFirst ? filter.getFragmentShader() : filter.getFragmentShader().replace("samplerExternalOES ", "sampler2D ");
        String vertexShader = filter.getVertexShader();
        state.programHandle = GlProgram.create((String)vertexShader, (String)fragmentShader);
        filter.onCreate(state.programHandle);
    }

    private void maybeDestroyProgram(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (!state.isProgramCreated) {
            return;
        }
        state.isProgramCreated = false;
        filter.onDestroy();
        GLES20.glDeleteProgram((int)state.programHandle);
        state.programHandle = -1;
    }

    private void maybeCreateFramebuffer(@NonNull Filter filter, boolean isFirst, boolean isLast) {
        State state = this.states.get(filter);
        if (isLast) {
            state.sizeChanged = false;
            return;
        }
        if (state.sizeChanged) {
            this.maybeDestroyFramebuffer(filter);
            state.sizeChanged = false;
        }
        if (!state.isFramebufferCreated) {
            state.isFramebufferCreated = true;
            state.outputTexture = new GlTexture(33984, 3553, state.size.getWidth(), state.size.getHeight());
            state.outputFramebuffer = new GlFramebuffer();
            state.outputFramebuffer.attach(state.outputTexture);
        }
    }

    private void maybeDestroyFramebuffer(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (!state.isFramebufferCreated) {
            return;
        }
        state.isFramebufferCreated = false;
        state.outputFramebuffer.release();
        state.outputFramebuffer = null;
        state.outputTexture.release();
        state.outputTexture = null;
    }

    private void maybeSetSize(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (this.size != null && !this.size.equals(state.size)) {
            state.size = this.size;
            state.sizeChanged = true;
            filter.setSize(this.size.getWidth(), this.size.getHeight());
        }
    }

    @Override
    public void onCreate(int programHandle) {
    }

    @Override
    @NonNull
    public String getVertexShader() {
        return "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroy() {
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                this.maybeDestroyFramebuffer(filter);
                this.maybeDestroyProgram(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int width, int height) {
        this.size = new Size(width, height);
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                this.maybeSetSize(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(long timestampUs, @NonNull float[] transformMatrix) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.filters.size(); ++i) {
                boolean isFirst = i == 0;
                boolean isLast = i == this.filters.size() - 1;
                Filter filter = this.filters.get(i);
                State state = this.states.get(filter);
                this.maybeSetSize(filter);
                this.maybeCreateProgram(filter, isFirst, isLast);
                this.maybeCreateFramebuffer(filter, isFirst, isLast);
                GLES20.glUseProgram((int)state.programHandle);
                if (!isLast) {
                    state.outputFramebuffer.bind();
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                } else {
                    GLES20.glBindFramebuffer((int)36160, (int)0);
                }
                if (isFirst) {
                    filter.draw(timestampUs, transformMatrix);
                } else {
                    filter.draw(timestampUs, Egloo.IDENTITY_MATRIX);
                }
                if (!isLast) {
                    state.outputTexture.bind();
                } else {
                    GLES20.glBindTexture((int)3553, (int)0);
                    GLES20.glActiveTexture((int)33984);
                }
                GLES20.glUseProgram((int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Filter copy() {
        Object object = this.lock;
        synchronized (object) {
            MultiFilter copy = new MultiFilter(new Filter[0]);
            if (this.size != null) {
                copy.setSize(this.size.getWidth(), this.size.getHeight());
            }
            for (Filter filter : this.filters) {
                copy.addFilter(filter.copy());
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter1(float parameter1) {
        this.parameter1 = parameter1;
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                if (!(filter instanceof OneParameterFilter)) continue;
                ((OneParameterFilter)filter).setParameter1(parameter1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter2(float parameter2) {
        this.parameter2 = parameter2;
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                if (!(filter instanceof TwoParameterFilter)) continue;
                ((TwoParameterFilter)filter).setParameter2(parameter2);
            }
        }
    }

    @Override
    public float getParameter1() {
        return this.parameter1;
    }

    @Override
    public float getParameter2() {
        return this.parameter2;
    }

    @VisibleForTesting
    static class State {
        @VisibleForTesting
        boolean isProgramCreated = false;
        @VisibleForTesting
        boolean isFramebufferCreated = false;
        private boolean sizeChanged = false;
        @VisibleForTesting
        Size size = null;
        private int programHandle = -1;
        private GlFramebuffer outputFramebuffer = null;
        private GlTexture outputTexture = null;

        State() {
        }
    }
}

