/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.orchestrator;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.internal.WorkerHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;

public class CameraOrchestrator {
    protected static final String TAG = CameraOrchestrator.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    protected final Callback mCallback;
    protected final ArrayDeque<Job<?>> mJobs = new ArrayDeque();
    protected boolean mJobRunning = false;
    protected final Object mJobsLock = new Object();

    public CameraOrchestrator(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    @NonNull
    public Task<Void> schedule(@NonNull String name, boolean dispatchExceptions, @NonNull Runnable job) {
        return this.scheduleDelayed(name, dispatchExceptions, 0L, job);
    }

    @NonNull
    public Task<Void> scheduleDelayed(@NonNull String name, boolean dispatchExceptions, long minDelay, final @NonNull Runnable job) {
        return this.scheduleInternal(name, dispatchExceptions, minDelay, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                job.run();
                return Tasks.forResult(null);
            }
        });
    }

    @NonNull
    public <T> Task<T> schedule(@NonNull String name, boolean dispatchExceptions, @NonNull Callable<Task<T>> scheduler) {
        return this.scheduleInternal(name, dispatchExceptions, 0L, scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private <T> Task<T> scheduleInternal(@NonNull String name, boolean dispatchExceptions, long minDelay, @NonNull Callable<Task<T>> scheduler) {
        LOG.i(name.toUpperCase(), "- Scheduling.");
        Job job = new Job(name, scheduler, dispatchExceptions, System.currentTimeMillis() + minDelay);
        Object object = this.mJobsLock;
        synchronized (object) {
            this.mJobs.addLast(job);
            this.sync(minDelay);
        }
        return job.source.getTask();
    }

    @GuardedBy(value="mJobsLock")
    private void sync(long after) {
        this.mCallback.getJobWorker("_sync").post(after, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Job<?> job = null;
                Object object = CameraOrchestrator.this.mJobsLock;
                synchronized (object) {
                    if (!CameraOrchestrator.this.mJobRunning) {
                        long now = System.currentTimeMillis();
                        for (Job<?> candidate : CameraOrchestrator.this.mJobs) {
                            if (candidate.startTime > now) continue;
                            job = candidate;
                            break;
                        }
                        if (job != null) {
                            CameraOrchestrator.this.mJobRunning = true;
                        }
                    }
                }
                if (job != null) {
                    CameraOrchestrator.this.execute(job);
                }
            }
        });
    }

    private <T> void execute(final @NonNull Job<T> job) {
        final WorkerHandler worker = this.mCallback.getJobWorker(job.name);
        worker.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LOG.i(job.name.toUpperCase(), "- Executing.");
                    Task task = job.scheduler.call();
                    CameraOrchestrator.onComplete(task, worker, new OnCompleteListener<T>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onComplete(@NonNull Task<T> task) {
                            Exception e = task.getException();
                            if (e != null) {
                                LOG.w(job.name.toUpperCase(), "- Finished with ERROR.", e);
                                if (job.dispatchExceptions) {
                                    CameraOrchestrator.this.mCallback.handleJobException(job.name, e);
                                }
                                job.source.trySetException(e);
                            } else if (task.isCanceled()) {
                                LOG.i(job.name.toUpperCase(), "- Finished because ABORTED.");
                                job.source.trySetException((Exception)new CancellationException());
                            } else {
                                LOG.i(job.name.toUpperCase(), "- Finished.");
                                job.source.trySetResult(task.getResult());
                            }
                            Object object = CameraOrchestrator.this.mJobsLock;
                            synchronized (object) {
                                CameraOrchestrator.this.executed(job);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOG.i(job.name.toUpperCase(), "- Finished with ERROR.", e);
                    if (job.dispatchExceptions) {
                        CameraOrchestrator.this.mCallback.handleJobException(job.name, e);
                    }
                    job.source.trySetException(e);
                    Object object = CameraOrchestrator.this.mJobsLock;
                    synchronized (object) {
                        CameraOrchestrator.this.executed(job);
                    }
                }
            }
        });
    }

    @GuardedBy(value="mJobsLock")
    private <T> void executed(Job<T> job) {
        if (!this.mJobRunning) {
            throw new IllegalStateException("mJobRunning was not true after completing job=" + job.name);
        }
        this.mJobRunning = false;
        this.mJobs.remove(job);
        this.sync(0L);
    }

    public void remove(@NonNull String name) {
        this.trim(name, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(@NonNull String name, int allowed) {
        Object object = this.mJobsLock;
        synchronized (object) {
            List scheduled = new ArrayList();
            for (Job<?> job : this.mJobs) {
                if (!job.name.equals(name)) continue;
                scheduled.add(job);
            }
            LOG.v("trim: name=", name, "scheduled=", scheduled.size(), "allowed=", allowed);
            int existing = Math.max(scheduled.size() - allowed, 0);
            if (existing > 0) {
                Collections.reverse(scheduled);
                scheduled = scheduled.subList(0, existing);
                for (Job job : scheduled) {
                    this.mJobs.remove(job);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mJobsLock;
        synchronized (object) {
            HashSet<String> all = new HashSet<String>();
            for (Job<?> job : this.mJobs) {
                all.add(job.name);
            }
            for (String string : all) {
                this.remove(string);
            }
        }
    }

    private static <T> void onComplete(final @NonNull Task<T> task, @NonNull WorkerHandler handler, final @NonNull OnCompleteListener<T> listener) {
        if (task.isComplete()) {
            handler.run(new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(task);
                }
            });
        } else {
            task.addOnCompleteListener(handler.getExecutor(), listener);
        }
    }

    protected static class Job<T> {
        public final String name;
        public final TaskCompletionSource<T> source = new TaskCompletionSource();
        public final Callable<Task<T>> scheduler;
        public final boolean dispatchExceptions;
        public final long startTime;

        private Job(@NonNull String name, @NonNull Callable<Task<T>> scheduler, boolean dispatchExceptions, long startTime) {
            this.name = name;
            this.scheduler = scheduler;
            this.dispatchExceptions = dispatchExceptions;
            this.startTime = startTime;
        }
    }

    public static interface Callback {
        @NonNull
        public WorkerHandler getJobWorker(@NonNull String var1);

        public void handleJobException(@NonNull String var1, @NonNull Exception var2);
    }
}

