/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.location.Location;
import android.os.Build;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.PictureFormat;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.CameraBaseEngine;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.EngineThread;
import com.otaliastudios.cameraview.engine.mappers.Camera1Mapper;
import com.otaliastudios.cameraview.engine.metering.Camera1MeteringTransform;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.engine.options.Camera1Options;
import com.otaliastudios.cameraview.engine.orchestrator.CameraState;
import com.otaliastudios.cameraview.frame.ByteBufferFrameManager;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.internal.CropHelper;
import com.otaliastudios.cameraview.metering.MeteringRegions;
import com.otaliastudios.cameraview.picture.Full1PictureRecorder;
import com.otaliastudios.cameraview.picture.Snapshot1PictureRecorder;
import com.otaliastudios.cameraview.picture.SnapshotGlPictureRecorder;
import com.otaliastudios.cameraview.preview.RendererCameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.Full1VideoRecorder;
import com.otaliastudios.cameraview.video.SnapshotVideoRecorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Camera1Engine
extends CameraBaseEngine
implements Camera.PreviewCallback,
Camera.ErrorCallback,
ByteBufferFrameManager.BufferCallback {
    private static final String JOB_FOCUS_RESET = "focus reset";
    private static final String JOB_FOCUS_END = "focus end";
    private static final int PREVIEW_FORMAT = 17;
    @VisibleForTesting
    static final int AUTOFOCUS_END_DELAY_MILLIS = 2500;
    private final Camera1Mapper mMapper = Camera1Mapper.get();
    private Camera mCamera;
    @VisibleForTesting
    int mCameraId;

    public Camera1Engine(@NonNull CameraEngine.Callback callback) {
        super(callback);
    }

    public void onError(int error, Camera camera) {
        int reason;
        String message = LOG.e("Internal Camera1 error.", error);
        RuntimeException runtime = new RuntimeException(message);
        switch (error) {
            case 2: 
            case 100: {
                reason = 3;
                break;
            }
            case 1: {
                reason = 3;
                break;
            }
            default: {
                reason = 0;
            }
        }
        throw new CameraException(runtime, reason);
    }

    @Override
    @EngineThread
    @NonNull
    protected List<Size> getPreviewStreamAvailableSizes() {
        List sizes;
        try {
            sizes = this.mCamera.getParameters().getSupportedPreviewSizes();
        }
        catch (Exception e) {
            LOG.e("getPreviewStreamAvailableSizes:", "Failed to compute preview size. Camera params is empty");
            throw new CameraException(e, 2);
        }
        ArrayList<Size> result = new ArrayList<Size>(sizes.size());
        for (Camera.Size size : sizes) {
            Size add = new Size(size.width, size.height);
            if (result.contains(add)) continue;
            result.add(add);
        }
        LOG.i("getPreviewStreamAvailableSizes:", result);
        return result;
    }

    @Override
    @EngineThread
    @NonNull
    protected List<Size> getFrameProcessingAvailableSizes() {
        return Collections.singletonList(this.mPreviewStreamSize);
    }

    @Override
    @EngineThread
    protected void onPreviewStreamSizeChanged() {
        this.restartPreview();
    }

    @Override
    @EngineThread
    protected boolean collectCameraInfo(@NonNull Facing facing) {
        int internalFacing = this.mMapper.mapFacing(facing);
        LOG.i("collectCameraInfo", "Facing:", facing, "Internal:", internalFacing, "Cameras:", Camera.getNumberOfCameras());
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internalFacing) continue;
            this.getAngles().setSensorOffset(facing, cameraInfo.orientation);
            this.mCameraId = i;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    @EngineThread
    protected Task<CameraOptions> onStartEngine() {
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            LOG.e("onStartEngine:", "Failed to connect. Maybe in use by another app?");
            throw new CameraException(e, 1);
        }
        if (this.mCamera == null) {
            LOG.e("onStartEngine:", "Failed to connect. Camera is null, maybe in use by another app or already released?");
            throw new CameraException(1);
        }
        this.mCamera.setErrorCallback((Camera.ErrorCallback)this);
        LOG.i("onStartEngine:", "Applying default parameters.");
        try {
            Camera.Parameters params = this.mCamera.getParameters();
            this.mCameraOptions = new Camera1Options(params, this.mCameraId, this.getAngles().flip(Reference.SENSOR, Reference.VIEW));
            this.applyAllParameters(params);
            this.mCamera.setParameters(params);
        }
        catch (Exception e) {
            LOG.e("onStartEngine:", "Failed to connect. Problem with camera params");
            throw new CameraException(e, 1);
        }
        try {
            this.mCamera.setDisplayOrientation(this.getAngles().offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE));
        }
        catch (Exception e) {
            LOG.e("onStartEngine:", "Failed to connect. Can't set display orientation, maybe preview already exists?");
            throw new CameraException(1);
        }
        LOG.i("onStartEngine:", "Ended");
        return Tasks.forResult((Object)this.mCameraOptions);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartBind() {
        block4: {
            LOG.i("onStartBind:", "Started");
            try {
                if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                    this.mCamera.setPreviewDisplay((SurfaceHolder)this.mPreview.getOutput());
                    break block4;
                }
                if (this.mPreview.getOutputClass() == SurfaceTexture.class) {
                    this.mCamera.setPreviewTexture((SurfaceTexture)this.mPreview.getOutput());
                    break block4;
                }
                throw new RuntimeException("Unknown CameraPreview output class.");
            }
            catch (IOException e) {
                LOG.e("onStartBind:", "Failed to bind.", e);
                throw new CameraException(e, 2);
            }
        }
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewStreamSize = this.computePreviewStreamSize();
        LOG.i("onStartBind:", "Returning");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartPreview() {
        Camera.Parameters params;
        LOG.i("onStartPreview", "Dispatching onCameraPreviewStreamSizeChanged.");
        this.getCallback().onCameraPreviewStreamSizeChanged();
        Size previewSize = this.getPreviewStreamSize(Reference.VIEW);
        if (previewSize == null) {
            throw new IllegalStateException("previewStreamSize should not be null at this point.");
        }
        this.mPreview.setStreamSize(previewSize.getWidth(), previewSize.getHeight());
        this.mPreview.setDrawRotation(0);
        try {
            params = this.mCamera.getParameters();
        }
        catch (Exception e) {
            LOG.e("onStartPreview:", "Failed to get params from camera. Maybe low level problem with camera or camera has already released?");
            throw new CameraException(e, 2);
        }
        params.setPreviewFormat(17);
        params.setPreviewSize(this.mPreviewStreamSize.getWidth(), this.mPreviewStreamSize.getHeight());
        if (this.getMode() == Mode.PICTURE) {
            params.setPictureSize(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        } else {
            Size pictureSize = this.computeCaptureSize(Mode.PICTURE);
            params.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        try {
            this.mCamera.setParameters(params);
        }
        catch (Exception e) {
            LOG.e("onStartPreview:", "Failed to set params for camera. Maybe incorrect parameter put in params?");
            throw new CameraException(e, 2);
        }
        this.mCamera.setPreviewCallbackWithBuffer(null);
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.getFrameManager().setUp(17, this.mPreviewStreamSize, this.getAngles());
        LOG.i("onStartPreview", "Starting preview with startPreview().");
        try {
            this.mCamera.startPreview();
        }
        catch (Exception e) {
            LOG.e("onStartPreview", "Failed to start preview.", e);
            throw new CameraException(e, 2);
        }
        LOG.i("onStartPreview", "Started preview.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopPreview() {
        LOG.i("onStopPreview:", "Started.");
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(true);
            this.mVideoRecorder = null;
        }
        this.mPictureRecorder = null;
        this.getFrameManager().release();
        LOG.i("onStopPreview:", "Releasing preview buffers.");
        this.mCamera.setPreviewCallbackWithBuffer(null);
        try {
            LOG.i("onStopPreview:", "Stopping preview.");
            this.mCamera.stopPreview();
            LOG.i("onStopPreview:", "Stopped preview.");
        }
        catch (Exception e) {
            LOG.e("stopPreview", "Could not stop preview", e);
        }
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopBind() {
        block4: {
            this.mPreviewStreamSize = null;
            this.mCaptureSize = null;
            try {
                if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                    this.mCamera.setPreviewDisplay(null);
                    break block4;
                }
                if (this.mPreview.getOutputClass() == SurfaceTexture.class) {
                    this.mCamera.setPreviewTexture(null);
                    break block4;
                }
                throw new RuntimeException("Unknown CameraPreview output class.");
            }
            catch (IOException e) {
                LOG.e("onStopBind", "Could not release surface", e);
            }
        }
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopEngine() {
        LOG.i("onStopEngine:", "About to clean up.");
        this.getOrchestrator().remove(JOB_FOCUS_RESET);
        this.getOrchestrator().remove(JOB_FOCUS_END);
        if (this.mCamera != null) {
            try {
                LOG.i("onStopEngine:", "Clean up.", "Releasing camera.");
                this.mCamera.release();
                LOG.i("onStopEngine:", "Clean up.", "Released camera.");
            }
            catch (Exception e) {
                LOG.w("onStopEngine:", "Clean up.", "Exception while releasing camera.", e);
            }
            this.mCamera = null;
            this.mCameraOptions = null;
        }
        this.mVideoRecorder = null;
        this.mCameraOptions = null;
        this.mCamera = null;
        LOG.w("onStopEngine:", "Clean up.", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    protected void onTakePicture(@NonNull PictureResult.Stub stub, boolean doMetering) {
        LOG.i("onTakePicture:", "executing.");
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getPictureSize(Reference.OUTPUT);
        this.mPictureRecorder = new Full1PictureRecorder(stub, this, this.mCamera);
        this.mPictureRecorder.take();
        LOG.i("onTakePicture:", "executed.");
    }

    @Override
    @EngineThread
    protected void onTakePictureSnapshot(@NonNull PictureResult.Stub stub, @NonNull AspectRatio outputRatio, boolean doMetering) {
        LOG.i("onTakePictureSnapshot:", "executing.");
        stub.size = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        if (this.mPreview instanceof RendererCameraPreview && Build.VERSION.SDK_INT >= 19) {
            stub.rotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
            this.mPictureRecorder = new SnapshotGlPictureRecorder(stub, this, (RendererCameraPreview)((Object)this.mPreview), outputRatio, this.getOverlay());
        } else {
            stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
            this.mPictureRecorder = new Snapshot1PictureRecorder(stub, this, this.mCamera, outputRatio);
        }
        this.mPictureRecorder.take();
        LOG.i("onTakePictureSnapshot:", "executed.");
    }

    @Override
    @EngineThread
    protected void onTakeVideo(@NonNull VideoResult.Stub stub) {
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getAngles().flip(Reference.SENSOR, Reference.OUTPUT) ? this.mCaptureSize.flip() : this.mCaptureSize;
        try {
            this.mCamera.unlock();
        }
        catch (Exception e) {
            this.onVideoResult(null, e);
            return;
        }
        this.mVideoRecorder = new Full1VideoRecorder(this, this.mCamera, this.mCameraId);
        this.mVideoRecorder.start(stub);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    @EngineThread
    protected void onTakeVideoSnapshot(@NonNull VideoResult.Stub stub, @NonNull AspectRatio outputRatio) {
        if (!(this.mPreview instanceof RendererCameraPreview)) {
            throw new IllegalStateException("Video snapshots are only supported with GL_SURFACE.");
        }
        if (Build.VERSION.SDK_INT < 18) {
            throw new IllegalStateException("Video snapshots are only supported on API 18+.");
        }
        RendererCameraPreview glPreview = (RendererCameraPreview)((Object)this.mPreview);
        Size outputSize = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        if (outputSize == null) {
            throw new IllegalStateException("outputSize should not be null.");
        }
        Rect outputCrop = CropHelper.computeCrop(outputSize, outputRatio);
        stub.size = outputSize = new Size(outputCrop.width(), outputCrop.height());
        stub.rotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
        stub.videoFrameRate = Math.round(this.mPreviewFrameRate);
        LOG.i("onTakeVideoSnapshot", "rotation:", stub.rotation, "size:", stub.size);
        this.mVideoRecorder = new SnapshotVideoRecorder(this, glPreview, this.getOverlay());
        this.mVideoRecorder.start(stub);
    }

    @Override
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        super.onVideoResult(result, exception);
        if (result == null) {
            this.mCamera.lock();
        }
    }

    private void applyAllParameters(@NonNull Camera.Parameters params) {
        params.setRecordingHint(this.getMode() == Mode.VIDEO);
        this.applyDefaultFocus(params);
        this.applyFlash(params, Flash.OFF);
        this.applyLocation(params, null);
        this.applyWhiteBalance(params, WhiteBalance.AUTO);
        this.applyHdr(params, Hdr.OFF);
        this.applyZoom(params, 0.0f);
        this.applyExposureCorrection(params, 0.0f);
        this.applyPlaySounds(this.mPlaySounds);
        this.applyPreviewFrameRate(params, 0.0f);
    }

    private void applyDefaultFocus(@NonNull Camera.Parameters params) {
        List modes = params.getSupportedFocusModes();
        if (this.getMode() == Mode.VIDEO && modes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
            return;
        }
        if (modes.contains("continuous-picture")) {
            params.setFocusMode("continuous-picture");
            return;
        }
        if (modes.contains("infinity")) {
            params.setFocusMode("infinity");
            return;
        }
        if (modes.contains("fixed")) {
            params.setFocusMode("fixed");
            return;
        }
    }

    @Override
    public void setFlash(@NonNull Flash flash) {
        final Flash old = this.mFlash;
        this.mFlash = flash;
        this.mFlashTask = this.getOrchestrator().scheduleStateful("flash (" + flash + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyFlash(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyFlash(@NonNull Camera.Parameters params, @NonNull Flash oldFlash) {
        if (this.mCameraOptions.supports(this.mFlash)) {
            params.setFlashMode(this.mMapper.mapFlash(this.mFlash));
            return true;
        }
        this.mFlash = oldFlash;
        return false;
    }

    @Override
    public void setLocation(@Nullable Location location) {
        final Location oldLocation = this.mLocation;
        this.mLocation = location;
        this.mLocationTask = this.getOrchestrator().scheduleStateful("location", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyLocation(params, oldLocation)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyLocation(@NonNull Camera.Parameters params, @Nullable Location oldLocation) {
        if (this.mLocation != null) {
            params.setGpsLatitude(this.mLocation.getLatitude());
            params.setGpsLongitude(this.mLocation.getLongitude());
            params.setGpsAltitude(this.mLocation.getAltitude());
            params.setGpsTimestamp(this.mLocation.getTime());
            params.setGpsProcessingMethod(this.mLocation.getProvider());
        }
        return true;
    }

    @Override
    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        final WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        this.mWhiteBalanceTask = this.getOrchestrator().scheduleStateful("white balance (" + whiteBalance + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyWhiteBalance(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyWhiteBalance(@NonNull Camera.Parameters params, @NonNull WhiteBalance oldWhiteBalance) {
        if (this.mCameraOptions.supports(this.mWhiteBalance)) {
            params.setWhiteBalance(this.mMapper.mapWhiteBalance(this.mWhiteBalance));
            params.remove("auto-whitebalance-lock");
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    @Override
    public void setHdr(@NonNull Hdr hdr) {
        final Hdr old = this.mHdr;
        this.mHdr = hdr;
        this.mHdrTask = this.getOrchestrator().scheduleStateful("hdr (" + hdr + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyHdr(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyHdr(@NonNull Camera.Parameters params, @NonNull Hdr oldHdr) {
        if (this.mCameraOptions.supports(this.mHdr)) {
            params.setSceneMode(this.mMapper.mapHdr(this.mHdr));
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @Override
    public void setZoom(float zoom, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mZoomValue;
        this.mZoomValue = zoom;
        this.getOrchestrator().trim("zoom", 20);
        this.mZoomTask = this.getOrchestrator().scheduleStateful("zoom", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyZoom(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                    if (notify) {
                        Camera1Engine.this.getCallback().dispatchOnZoomChanged(Camera1Engine.this.mZoomValue, points);
                    }
                }
            }
        });
    }

    private boolean applyZoom(@NonNull Camera.Parameters params, float oldZoom) {
        if (this.mCameraOptions.isZoomSupported()) {
            float max = params.getMaxZoom();
            params.setZoom((int)(this.mZoomValue * max));
            this.mCamera.setParameters(params);
            return true;
        }
        this.mZoomValue = oldZoom;
        return false;
    }

    @Override
    public void setExposureCorrection(float EVvalue, final @NonNull float[] bounds, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mExposureCorrectionValue;
        this.mExposureCorrectionValue = EVvalue;
        this.getOrchestrator().trim("exposure correction", 20);
        this.mExposureCorrectionTask = this.getOrchestrator().scheduleStateful("exposure correction", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyExposureCorrection(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                    if (notify) {
                        Camera1Engine.this.getCallback().dispatchOnExposureCorrectionChanged(Camera1Engine.this.mExposureCorrectionValue, bounds, points);
                    }
                }
            }
        });
    }

    private boolean applyExposureCorrection(@NonNull Camera.Parameters params, float oldExposureCorrection) {
        if (this.mCameraOptions.isExposureCorrectionSupported()) {
            float max = this.mCameraOptions.getExposureCorrectionMaxValue();
            float val = this.mExposureCorrectionValue;
            float min = this.mCameraOptions.getExposureCorrectionMinValue();
            this.mExposureCorrectionValue = val = val < min ? min : (val > max ? max : val);
            int indexValue = (int)(this.mExposureCorrectionValue / params.getExposureCompensationStep());
            params.setExposureCompensation(indexValue);
            return true;
        }
        this.mExposureCorrectionValue = oldExposureCorrection;
        return false;
    }

    @Override
    public void setPlaySounds(boolean playSounds) {
        final boolean old = this.mPlaySounds;
        this.mPlaySounds = playSounds;
        this.mPlaySoundsTask = this.getOrchestrator().scheduleStateful("play sounds (" + playSounds + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera1Engine.this.applyPlaySounds(old);
            }
        });
    }

    @TargetApi(value=17)
    private boolean applyPlaySounds(boolean oldPlaySound) {
        if (Build.VERSION.SDK_INT >= 17) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
            if (info.canDisableShutterSound) {
                try {
                    return this.mCamera.enableShutterSound(this.mPlaySounds);
                }
                catch (RuntimeException exception) {
                    return false;
                }
            }
        }
        if (this.mPlaySounds) {
            return true;
        }
        this.mPlaySounds = oldPlaySound;
        return false;
    }

    @Override
    public void setPreviewFrameRate(float previewFrameRate) {
        final float old = previewFrameRate;
        this.mPreviewFrameRate = previewFrameRate;
        this.mPreviewFrameRateTask = this.getOrchestrator().scheduleStateful("preview fps (" + previewFrameRate + ")", CameraState.ENGINE, new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                if (Camera1Engine.this.applyPreviewFrameRate(params, old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
            }
        });
    }

    private boolean applyPreviewFrameRate(@NonNull Camera.Parameters params, float oldPreviewFrameRate) {
        List fpsRanges = params.getSupportedPreviewFpsRange();
        this.sortRanges(fpsRanges);
        if (this.mPreviewFrameRate == 0.0f) {
            for (int[] fpsRange : fpsRanges) {
                float lower = (float)fpsRange[0] / 1000.0f;
                float upper = (float)fpsRange[1] / 1000.0f;
                if (!(lower <= 30.0f && 30.0f <= upper) && (!(lower <= 24.0f) || !(24.0f <= upper))) continue;
                params.setPreviewFpsRange(fpsRange[0], fpsRange[1]);
                return true;
            }
        } else {
            this.mPreviewFrameRate = Math.min(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMaxValue());
            this.mPreviewFrameRate = Math.max(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMinValue());
            for (int[] fpsRange : fpsRanges) {
                float lower = (float)fpsRange[0] / 1000.0f;
                float upper = (float)fpsRange[1] / 1000.0f;
                float rate = Math.round(this.mPreviewFrameRate);
                if (!(lower <= rate) || !(rate <= upper)) continue;
                params.setPreviewFpsRange(fpsRange[0], fpsRange[1]);
                return true;
            }
        }
        this.mPreviewFrameRate = oldPreviewFrameRate;
        return false;
    }

    private void sortRanges(List<int[]> fpsRanges) {
        if (this.getPreviewFrameRateExact() && this.mPreviewFrameRate != 0.0f) {
            Collections.sort(fpsRanges, new Comparator<int[]>(){

                @Override
                public int compare(int[] range1, int[] range2) {
                    return range1[1] - range1[0] - (range2[1] - range2[0]);
                }
            });
        } else {
            Collections.sort(fpsRanges, new Comparator<int[]>(){

                @Override
                public int compare(int[] range1, int[] range2) {
                    return range2[1] - range2[0] - (range1[1] - range1[0]);
                }
            });
        }
    }

    @Override
    public void setPictureFormat(@NonNull PictureFormat pictureFormat) {
        if (pictureFormat != PictureFormat.JPEG) {
            throw new UnsupportedOperationException("Unsupported picture format: " + pictureFormat);
        }
        this.mPictureFormat = pictureFormat;
    }

    @Override
    @NonNull
    protected FrameManager instantiateFrameManager(int poolSize) {
        return new ByteBufferFrameManager(poolSize, this);
    }

    @Override
    @NonNull
    public ByteBufferFrameManager getFrameManager() {
        return (ByteBufferFrameManager)super.getFrameManager();
    }

    @Override
    public void setHasFrameProcessors(boolean hasFrameProcessors) {
        this.mHasFrameProcessors = hasFrameProcessors;
    }

    @Override
    public void setFrameProcessingFormat(int format) {
        this.mFrameProcessingFormat = 17;
    }

    @Override
    public void onBufferAvailable(@NonNull byte[] buffer) {
        if (this.getState().isAtLeast(CameraState.ENGINE) && this.getTargetState().isAtLeast(CameraState.ENGINE)) {
            this.mCamera.addCallbackBuffer(buffer);
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (data == null) {
            return;
        }
        Frame frame = this.getFrameManager().getFrame(data, System.currentTimeMillis());
        if (frame != null) {
            this.getCallback().dispatchFrame(frame);
        }
    }

    @Override
    public void startAutoFocus(final @Nullable Gesture gesture, final @NonNull MeteringRegions regions, final @NonNull PointF legacyPoint) {
        this.getOrchestrator().scheduleStateful("auto focus", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                if (!Camera1Engine.this.mCameraOptions.isAutoFocusSupported()) {
                    return;
                }
                Camera1MeteringTransform transform = new Camera1MeteringTransform(Camera1Engine.this.getAngles(), Camera1Engine.this.getPreview().getSurfaceSize());
                MeteringRegions transformed = regions.transform(transform);
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                int maxAF = params.getMaxNumFocusAreas();
                int maxAE = params.getMaxNumMeteringAreas();
                if (maxAF > 0) {
                    params.setFocusAreas(transformed.get(maxAF, transform));
                }
                if (maxAE > 0) {
                    params.setMeteringAreas(transformed.get(maxAE, transform));
                }
                params.setFocusMode("auto");
                Camera1Engine.this.mCamera.setParameters(params);
                Camera1Engine.this.getCallback().dispatchOnFocusStart(gesture, legacyPoint);
                Camera1Engine.this.getOrchestrator().remove(Camera1Engine.JOB_FOCUS_END);
                Camera1Engine.this.getOrchestrator().scheduleDelayed(Camera1Engine.JOB_FOCUS_END, true, 2500L, new Runnable(){

                    @Override
                    public void run() {
                        Camera1Engine.this.getCallback().dispatchOnFocusEnd(gesture, false, legacyPoint);
                    }
                });
                try {
                    Camera1Engine.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            Camera1Engine.this.getOrchestrator().remove(Camera1Engine.JOB_FOCUS_END);
                            Camera1Engine.this.getOrchestrator().remove(Camera1Engine.JOB_FOCUS_RESET);
                            Camera1Engine.this.getCallback().dispatchOnFocusEnd(gesture, success, legacyPoint);
                            if (Camera1Engine.this.shouldResetAutoFocus()) {
                                Camera1Engine.this.getOrchestrator().scheduleStatefulDelayed(Camera1Engine.JOB_FOCUS_RESET, CameraState.ENGINE, Camera1Engine.this.getAutoFocusResetDelay(), new Runnable(){

                                    @Override
                                    public void run() {
                                        Camera1Engine.this.mCamera.cancelAutoFocus();
                                        Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                                        int maxAF = params.getMaxNumFocusAreas();
                                        int maxAE = params.getMaxNumMeteringAreas();
                                        if (maxAF > 0) {
                                            params.setFocusAreas(null);
                                        }
                                        if (maxAE > 0) {
                                            params.setMeteringAreas(null);
                                        }
                                        Camera1Engine.this.applyDefaultFocus(params);
                                        Camera1Engine.this.mCamera.setParameters(params);
                                    }
                                });
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    CameraEngine.LOG.e("startAutoFocus:", "Error calling autoFocus", e);
                }
            }
        });
    }
}

