/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.example;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pService;
import org.tron.p2p.discover.Node;
import org.tron.p2p.dns.update.DnsType;
import org.tron.p2p.dns.update.PublishConfig;
import org.tron.p2p.stats.P2pStats;

public class DnsExample1 {
    private P2pService p2pService = new P2pService();

    public void startP2pService() {
        P2pConfig config = new P2pConfig();
        this.initDnsPublishConfig(config);
        this.p2pService.start(config);
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void closeP2pService() {
        this.p2pService.close();
    }

    public void connect(InetSocketAddress address) {
        this.p2pService.connect(address);
    }

    public P2pStats getP2pStats() {
        return this.p2pService.getP2pStats();
    }

    public List<Node> getAllNodes() {
        return this.p2pService.getAllNodes();
    }

    public List<Node> getTableNodes() {
        return this.p2pService.getTableNodes();
    }

    public List<Node> getConnectableNodes() {
        return this.p2pService.getConnectableNodes();
    }

    private void initDnsPublishConfig(P2pConfig config) {
        config.setNetworkId(11111);
        config.setPort(18888);
        config.setDiscoverEnable(true);
        ArrayList<InetSocketAddress> seedNodeList = new ArrayList<InetSocketAddress>();
        seedNodeList.add(new InetSocketAddress("13.124.62.58", 18888));
        seedNodeList.add(new InetSocketAddress("2600:1f13:908:1b00:e1fd:5a84:251c:a32a", 18888));
        seedNodeList.add(new InetSocketAddress("127.0.0.4", 18888));
        config.setSeedNodes(seedNodeList);
        PublishConfig publishConfig = new PublishConfig();
        publishConfig.setDnsPrivate("b71c71a67e1177ad4e901695e1b4b9ee17ae16c6668d313eac2f96dbcda3f291");
        publishConfig.setDnsDomain("nodes.example.org");
        String[] urls = new String[]{"tree://APFGGTFOBVE2ZNAB3CSMNNX6RRK3ODIRLP2AA5U4YFAA6MSYZUYTQ@nodes.example1.org", "tree://APFGGTFOBVE2ZNAB3CSMNNX6RRK3ODIRLP2AA5U4YFAA6MSYZUYTQ@nodes.example2.org"};
        publishConfig.setKnownTreeUrls(Arrays.asList(urls));
        publishConfig.setDnsType(DnsType.AwsRoute53);
        publishConfig.setAccessKeyId("your access key");
        publishConfig.setAccessKeySecret("your access key secret");
        publishConfig.setAwsHostZoneId("your host zone id");
        publishConfig.setAwsRegion("us-east-1");
        publishConfig.setDnsPublishEnable(true);
        config.setPublishConfig(publishConfig);
    }
}

