/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.tree;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.tree.Algorithm;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.exception.DnsException;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.ByteArray;

public class RootEntry
implements Entry {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private Discover.DnsRoot dnsRoot;

    public RootEntry(Discover.DnsRoot dnsRoot) {
        this.dnsRoot = dnsRoot;
    }

    public String getERoot() {
        return new String(this.dnsRoot.getTreeRoot().getERoot().toByteArray());
    }

    public String getLRoot() {
        return new String(this.dnsRoot.getTreeRoot().getLRoot().toByteArray());
    }

    public int getSeq() {
        return this.dnsRoot.getTreeRoot().getSeq();
    }

    public void setSeq(int seq) {
        Discover.DnsRoot.TreeRoot.Builder builder = this.dnsRoot.getTreeRoot().toBuilder();
        builder.setSeq(seq);
        Discover.DnsRoot.Builder dnsRootBuilder = this.dnsRoot.toBuilder();
        dnsRootBuilder.setTreeRoot(builder.build());
        this.dnsRoot = dnsRootBuilder.build();
    }

    public byte[] getSignature() {
        return Algorithm.decode64(new String(this.dnsRoot.getSignature().toByteArray()));
    }

    public void setSignature(byte[] signature) {
        Discover.DnsRoot.Builder dnsRootBuilder = this.dnsRoot.toBuilder();
        dnsRootBuilder.setSignature(ByteString.copyFrom((byte[])Algorithm.encode64(signature).getBytes()));
        this.dnsRoot = dnsRootBuilder.build();
    }

    public RootEntry(String eRoot, String lRoot, int seq) {
        Discover.DnsRoot.TreeRoot.Builder builder = Discover.DnsRoot.TreeRoot.newBuilder();
        builder.setERoot(ByteString.copyFrom((byte[])eRoot.getBytes()));
        builder.setLRoot(ByteString.copyFrom((byte[])lRoot.getBytes()));
        builder.setSeq(seq);
        Discover.DnsRoot.Builder dnsRootBuilder = Discover.DnsRoot.newBuilder();
        dnsRootBuilder.setTreeRoot(builder.build());
        this.dnsRoot = dnsRootBuilder.build();
    }

    public static RootEntry parseEntry(String e) throws DnsException {
        Discover.DnsRoot dnsRoot1;
        String value = e.substring("tree-root-v1:".length());
        try {
            dnsRoot1 = Discover.DnsRoot.parseFrom(Algorithm.decode64(value));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new DnsException(DnsException.TypeEnum.INVALID_ROOT, String.format("proto=[%s]", e), ex);
        }
        byte[] signature = Algorithm.decode64(new String(dnsRoot1.getSignature().toByteArray()));
        if (signature.length != 65) {
            throw new DnsException(DnsException.TypeEnum.INVALID_SIGNATURE, String.format("signature's length(%d) != 65, signature: %s", signature.length, ByteArray.toHexString(signature)));
        }
        return new RootEntry(dnsRoot1);
    }

    public static RootEntry parseEntry(String e, String publicKey, String domain) throws SignatureException, DnsException {
        log.info("Domain:{}, public key:{}", (Object)domain, (Object)publicKey);
        RootEntry rootEntry = RootEntry.parseEntry(e);
        boolean verify = Algorithm.verifySignature(publicKey, rootEntry.toString(), rootEntry.getSignature());
        if (!verify) {
            throw new DnsException(DnsException.TypeEnum.INVALID_SIGNATURE, String.format("verify signature failed! data:[%s], publicKey:%s, domain:%s", e, publicKey, domain));
        }
        if (!Algorithm.isValidHash(rootEntry.getERoot()) || !Algorithm.isValidHash(rootEntry.getLRoot())) {
            throw new DnsException(DnsException.TypeEnum.INVALID_CHILD, "eroot:" + rootEntry.getERoot() + " lroot:" + rootEntry.getLRoot());
        }
        log.info("Get dnsRoot:[{}]", (Object)rootEntry.dnsRoot.toString());
        return rootEntry;
    }

    public String toString() {
        return this.dnsRoot.getTreeRoot().toString();
    }

    public String toFormat() {
        return "tree-root-v1:" + Algorithm.encode64(this.dnsRoot.toByteArray());
    }

    public Discover.DnsRoot getDnsRoot() {
        return this.dnsRoot;
    }
}

