/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.sync;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.sync.Client;
import org.tron.p2p.dns.tree.BranchEntry;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.exception.DnsException;
import org.xbill.DNS.TextParseException;

public class SubtreeSync {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public Client client;
    public LinkEntry linkEntry;
    public String root;
    public boolean link;
    public int leaves;
    public LinkedList<String> missing;

    public SubtreeSync(Client c, LinkEntry linkEntry, String root, boolean link) {
        this.client = c;
        this.linkEntry = linkEntry;
        this.root = root;
        this.link = link;
        this.leaves = 0;
        this.missing = new LinkedList();
        this.missing.add(root);
    }

    public boolean done() {
        return this.missing.isEmpty();
    }

    public void resolveAll(Map<String, Entry> dest) throws DnsException, UnknownHostException, TextParseException {
        while (!this.done()) {
            String hash = this.missing.peek();
            Entry entry = this.resolveNext(hash);
            if (entry != null) {
                dest.put(hash, entry);
            }
            this.missing.poll();
        }
    }

    public Entry resolveNext(String hash) throws DnsException, TextParseException, UnknownHostException {
        Entry entry = this.client.resolveEntry(this.linkEntry.getDomain(), hash);
        if (entry instanceof NodesEntry) {
            if (this.link) {
                throw new DnsException(DnsException.TypeEnum.NODES_IN_LINK_TREE, "");
            }
            ++this.leaves;
        } else if (entry instanceof LinkEntry) {
            if (!this.link) {
                throw new DnsException(DnsException.TypeEnum.LINK_IN_NODES_TREE, "");
            }
            ++this.leaves;
        } else if (entry instanceof BranchEntry) {
            BranchEntry branchEntry = (BranchEntry)entry;
            this.missing.addAll(Arrays.asList(branchEntry.getChildren()));
        }
        return entry;
    }
}

