/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns;

import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.kad.KadMessage;
import org.tron.p2p.dns.tree.Algorithm;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.ByteArray;

public class DnsNode
extends Node
implements Comparable<DnsNode> {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static final long serialVersionUID = 6689513341024130226L;
    private String v4Hex = "00000000";
    private String v6Hex = "00000000000000000000000000000000";

    public DnsNode(byte[] id, String hostV4, String hostV6, int port) throws UnknownHostException {
        super(null, hostV4, hostV6, port);
        if (StringUtils.isNotEmpty((CharSequence)hostV4)) {
            this.v4Hex = this.ipToString(hostV4);
        }
        if (StringUtils.isNotEmpty((CharSequence)hostV6)) {
            this.v6Hex = this.ipToString(hostV6);
        }
    }

    public static String compress(List<DnsNode> nodes) {
        Discover.EndPoints.Builder builder = Discover.EndPoints.newBuilder();
        nodes.forEach(node -> {
            Discover.Endpoint endpoint = KadMessage.getEndpointFromNode(node);
            builder.addNodes(endpoint);
        });
        return Algorithm.encode64(builder.build().toByteArray());
    }

    public static List<DnsNode> decompress(String base64Content) throws InvalidProtocolBufferException, UnknownHostException {
        byte[] data = Algorithm.decode64(base64Content);
        Discover.EndPoints endPoints = Discover.EndPoints.parseFrom(data);
        ArrayList<DnsNode> dnsNodes = new ArrayList<DnsNode>();
        for (Discover.Endpoint endpoint : endPoints.getNodesList()) {
            DnsNode dnsNode = new DnsNode(endpoint.getNodeId().toByteArray(), new String(endpoint.getAddress().toByteArray()), new String(endpoint.getAddressIpv6().toByteArray()), endpoint.getPort());
            dnsNodes.add(dnsNode);
        }
        return dnsNodes;
    }

    public String ipToString(String ip) throws UnknownHostException {
        byte[] bytes = InetAddress.getByName(ip).getAddress();
        return ByteArray.toHexString(bytes);
    }

    public int getNetworkA() {
        if (StringUtils.isNotEmpty((CharSequence)this.hostV4)) {
            return Integer.parseInt(this.hostV4.split("\\.")[0]);
        }
        return 0;
    }

    @Override
    public int compareTo(DnsNode o) {
        if (this.v4Hex.compareTo(o.v4Hex) != 0) {
            return this.v4Hex.compareTo(o.v4Hex);
        }
        if (this.v6Hex.compareTo(o.v6Hex) != 0) {
            return this.v6Hex.compareTo(o.v6Hex);
        }
        return this.port - o.port;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DnsNode)) {
            return false;
        }
        DnsNode other = (DnsNode)o;
        return this.v4Hex.equals(other.v4Hex) && this.v6Hex.equals(other.v6Hex) && this.port == other.port;
    }
}

