/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.protocol.kad.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.protocol.kad.table.DistanceComparator;
import org.tron.p2p.discover.protocol.kad.table.NodeBucket;
import org.tron.p2p.discover.protocol.kad.table.NodeEntry;

public class NodeTable {
    private final Node node;
    private transient NodeBucket[] buckets;
    private transient Map<String, NodeEntry> nodes;

    public NodeTable(Node n) {
        this.node = n;
        this.initialize();
    }

    public Node getNode() {
        return this.node;
    }

    public final void initialize() {
        this.nodes = new HashMap<String, NodeEntry>();
        this.buckets = new NodeBucket[17];
        for (int i = 0; i < 17; ++i) {
            this.buckets[i] = new NodeBucket(i);
        }
    }

    public synchronized Node addNode(Node n) {
        if (n.getHostKey().equals(this.node.getHostKey())) {
            return null;
        }
        NodeEntry entry = this.nodes.get(n.getHostKey());
        if (entry != null) {
            entry.touch();
            return null;
        }
        NodeEntry e = new NodeEntry(this.node.getId(), n);
        NodeEntry lastSeen = this.buckets[this.getBucketId(e)].addNode(e);
        if (lastSeen != null) {
            return lastSeen.getNode();
        }
        this.nodes.put(n.getHostKey(), e);
        return null;
    }

    public synchronized void dropNode(Node n) {
        NodeEntry entry = this.nodes.get(n.getHostKey());
        if (entry != null) {
            this.nodes.remove(n.getHostKey());
            this.buckets[this.getBucketId(entry)].dropNode(entry);
        }
    }

    public synchronized boolean contains(Node n) {
        return this.nodes.containsKey(n.getHostKey());
    }

    public synchronized void touchNode(Node n) {
        NodeEntry entry = this.nodes.get(n.getHostKey());
        if (entry != null) {
            entry.touch();
        }
    }

    public int getBucketsCount() {
        int i = 0;
        for (NodeBucket b : this.buckets) {
            if (b.getNodesCount() <= 0) continue;
            ++i;
        }
        return i;
    }

    public int getBucketId(NodeEntry e) {
        int id = e.getDistance() - 1;
        return Math.max(id, 0);
    }

    public synchronized int getNodesCount() {
        return this.nodes.size();
    }

    public synchronized List<NodeEntry> getAllNodes() {
        return new ArrayList<NodeEntry>(this.nodes.values());
    }

    public synchronized List<Node> getClosestNodes(byte[] targetId) {
        List<NodeEntry> closestEntries = this.getAllNodes();
        List<Node> closestNodes = new ArrayList<Node>();
        for (NodeEntry e : closestEntries) {
            closestNodes.add((Node)e.getNode().clone());
        }
        Collections.sort(closestNodes, new DistanceComparator(targetId));
        if (closestNodes.size() > 16) {
            closestNodes = closestNodes.subList(0, 16);
        }
        return closestNodes;
    }

    public synchronized List<Node> getTableNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (NodeEntry nodeEntry : this.nodes.values()) {
            nodeList.add(nodeEntry.getNode());
        }
        return nodeList;
    }
}

