/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.message;

import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    KEEP_ALIVE_PING(-1),
    KEEP_ALIVE_PONG(-2),
    HANDSHAKE_HELLO(-3),
    STATUS(-4),
    DISCONNECT(-5),
    UNKNOWN(-128);

    private final byte type;
    private static final Map<Byte, MessageType> map;

    private MessageType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static MessageType fromByte(byte type) {
        MessageType typeEnum = map.get(type);
        return typeEnum == null ? UNKNOWN : typeEnum;
    }

    static {
        map = new HashMap<Byte, MessageType>();
        for (MessageType value : MessageType.values()) {
            map.put(value.type, value);
        }
    }
}

