/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.business.detect;

import java.net.InetSocketAddress;
import org.tron.p2p.connection.message.detect.StatusMessage;
import org.tron.p2p.discover.Node;

public class NodeStat {
    private int totalCount;
    private long lastDetectTime;
    private long lastSuccessDetectTime;
    private StatusMessage statusMessage;
    private Node node;
    private InetSocketAddress socketAddress;

    public NodeStat(Node node) {
        this.node = node;
        this.socketAddress = node.getPreferInetSocketAddress();
    }

    public boolean finishDetect() {
        return this.lastDetectTime == this.lastSuccessDetectTime;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public long getLastDetectTime() {
        return this.lastDetectTime;
    }

    public long getLastSuccessDetectTime() {
        return this.lastSuccessDetectTime;
    }

    public StatusMessage getStatusMessage() {
        return this.statusMessage;
    }

    public Node getNode() {
        return this.node;
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setLastDetectTime(long lastDetectTime) {
        this.lastDetectTime = lastDetectTime;
    }

    public void setLastSuccessDetectTime(long lastSuccessDetectTime) {
        this.lastSuccessDetectTime = lastSuccessDetectTime;
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeStat)) {
            return false;
        }
        NodeStat other = (NodeStat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getLastDetectTime() != other.getLastDetectTime()) {
            return false;
        }
        if (this.getLastSuccessDetectTime() != other.getLastSuccessDetectTime()) {
            return false;
        }
        StatusMessage this$statusMessage = this.getStatusMessage();
        StatusMessage other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        Node this$node = this.getNode();
        Node other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        InetSocketAddress this$socketAddress = this.getSocketAddress();
        InetSocketAddress other$socketAddress = other.getSocketAddress();
        return !(this$socketAddress == null ? other$socketAddress != null : !((Object)this$socketAddress).equals(other$socketAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeStat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalCount();
        long $lastDetectTime = this.getLastDetectTime();
        result = result * 59 + (int)($lastDetectTime >>> 32 ^ $lastDetectTime);
        long $lastSuccessDetectTime = this.getLastSuccessDetectTime();
        result = result * 59 + (int)($lastSuccessDetectTime >>> 32 ^ $lastSuccessDetectTime);
        StatusMessage $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        Node $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        InetSocketAddress $socketAddress = this.getSocketAddress();
        result = result * 59 + ($socketAddress == null ? 43 : ((Object)$socketAddress).hashCode());
        return result;
    }

    public String toString() {
        return "NodeStat(totalCount=" + this.getTotalCount() + ", lastDetectTime=" + this.getLastDetectTime() + ", lastSuccessDetectTime=" + this.getLastSuccessDetectTime() + ", statusMessage=" + this.getStatusMessage() + ", node=" + this.getNode() + ", socketAddress=" + this.getSocketAddress() + ")";
    }
}

