/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.business.upgrade.UpgradeController;
import org.tron.p2p.connection.message.Message;
import org.tron.p2p.connection.message.handshake.HelloMessage;
import org.tron.p2p.connection.socket.MessageHandler;
import org.tron.p2p.connection.socket.P2pProtobufVarint32FrameDecoder;
import org.tron.p2p.discover.Node;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.stats.TrafficStats;
import org.tron.p2p.utils.ByteArray;

public class Channel {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public volatile boolean waitForPong = false;
    public volatile long pingSent = System.currentTimeMillis();
    private HelloMessage helloMessage;
    private Node node;
    private int version;
    private ChannelHandlerContext ctx;
    private InetSocketAddress inetSocketAddress;
    private InetAddress inetAddress;
    private volatile long disconnectTime;
    private volatile boolean isDisconnect = false;
    private long lastSendTime = System.currentTimeMillis();
    private final long startTime = System.currentTimeMillis();
    private boolean isActive = false;
    private boolean isTrustPeer;
    private volatile boolean finishHandshake;
    private String nodeId;
    private boolean discoveryMode;
    private long avgLatency;
    private long count;

    public void init(ChannelPipeline pipeline, String nodeId, boolean discoveryMode) {
        this.discoveryMode = discoveryMode;
        this.nodeId = nodeId;
        this.isActive = StringUtils.isNotEmpty((CharSequence)nodeId);
        MessageHandler messageHandler = new MessageHandler(this);
        pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(60L, TimeUnit.SECONDS));
        pipeline.addLast(new ChannelHandler[]{TrafficStats.tcp});
        pipeline.addLast("protoPrepend", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender());
        pipeline.addLast("protoDecode", (ChannelHandler)new P2pProtobufVarint32FrameDecoder(this));
        pipeline.addLast("messageHandler", (ChannelHandler)messageHandler);
    }

    public void processException(Throwable throwable) {
        Throwable baseThrowable = throwable;
        try {
            baseThrowable = Throwables.getRootCause((Throwable)baseThrowable);
        }
        catch (IllegalArgumentException e) {
            baseThrowable = e.getCause();
            log.warn("Loop in causal chain detected");
        }
        SocketAddress address = this.ctx.channel().remoteAddress();
        if (throwable instanceof ReadTimeoutException || throwable instanceof IOException || throwable instanceof CorruptedFrameException) {
            log.warn("Close peer {}, reason: {}", (Object)address, (Object)throwable.getMessage());
        } else if (baseThrowable instanceof P2pException) {
            log.warn("Close peer {}, type: ({}), info: {}", new Object[]{address, ((P2pException)baseThrowable).getType(), baseThrowable.getMessage()});
        } else {
            log.error("Close peer {}, exception caught", (Object)address, (Object)throwable);
        }
        this.close();
    }

    public void setHelloMessage(HelloMessage helloMessage) {
        this.helloMessage = helloMessage;
        this.node = helloMessage.getFrom();
        this.nodeId = this.node.getHexId();
        this.version = helloMessage.getVersion();
    }

    public void setChannelHandlerContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        this.inetAddress = this.inetSocketAddress.getAddress();
        this.isTrustPeer = Parameter.p2pConfig.getTrustNodes().contains(this.inetAddress);
    }

    public void close(long banTime) {
        this.isDisconnect = true;
        this.disconnectTime = System.currentTimeMillis();
        ChannelManager.banNode(this.inetAddress, banTime);
        this.ctx.close();
    }

    public void close() {
        this.close(60000L);
    }

    public void send(Message message) {
        if (message.needToLog()) {
            log.info("Send message to channel {}, {}", (Object)this.inetSocketAddress, (Object)message);
        } else {
            log.debug("Send message to channel {}, {}", (Object)this.inetSocketAddress, (Object)message);
        }
        this.send(message.getSendData());
    }

    public void send(byte[] data) {
        try {
            byte type = data[0];
            if (this.isDisconnect) {
                log.warn("Send to {} failed as channel has closed, message-type:{} ", (Object)this.ctx.channel().remoteAddress(), (Object)type);
                return;
            }
            if (this.finishHandshake) {
                data = UpgradeController.codeSendData(this.version, data);
            }
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data);
            this.ctx.writeAndFlush((Object)byteBuf).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess() && !this.isDisconnect) {
                    log.warn("Send to {} failed, message-type:{}, cause:{}", new Object[]{this.ctx.channel().remoteAddress(), ByteArray.byte2int(type), future.cause().getMessage()});
                }
            }));
            this.setLastSendTime(System.currentTimeMillis());
        }
        catch (Exception e) {
            log.warn("Send message to {} failed, {}", (Object)this.inetSocketAddress, (Object)e.getMessage());
            this.ctx.channel().close();
        }
    }

    public void updateAvgLatency(long latency) {
        long total = this.avgLatency * this.count;
        ++this.count;
        this.avgLatency = (total + latency) / this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return Objects.equals(this.inetSocketAddress, channel.inetSocketAddress);
    }

    public int hashCode() {
        return this.inetSocketAddress.hashCode();
    }

    public String toString() {
        return String.format("%s | %s", this.inetSocketAddress, StringUtils.isEmpty((CharSequence)this.nodeId) ? "<null>" : this.nodeId);
    }

    public HelloMessage getHelloMessage() {
        return this.helloMessage;
    }

    public Node getNode() {
        return this.node;
    }

    public int getVersion() {
        return this.version;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    public boolean isDisconnect() {
        return this.isDisconnect;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public void setLastSendTime(long lastSendTime) {
        this.lastSendTime = lastSendTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isTrustPeer() {
        return this.isTrustPeer;
    }

    public boolean isFinishHandshake() {
        return this.finishHandshake;
    }

    public void setFinishHandshake(boolean finishHandshake) {
        this.finishHandshake = finishHandshake;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setDiscoveryMode(boolean discoveryMode) {
        this.discoveryMode = discoveryMode;
    }

    public boolean isDiscoveryMode() {
        return this.discoveryMode;
    }

    public long getAvgLatency() {
        return this.avgLatency;
    }
}

