/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.base;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.ByteArray;

public class Parameter {
    public static int version = 1;
    public static final int TCP_NETTY_WORK_THREAD_NUM = 0;
    public static final int UDP_NETTY_WORK_THREAD_NUM = 1;
    public static final int NODE_CONNECTION_TIMEOUT = 2000;
    public static final int KEEP_ALIVE_TIMEOUT = 20000;
    public static final int PING_TIMEOUT = 20000;
    public static final int NETWORK_TIME_DIFF = 1000;
    public static final long DEFAULT_BAN_TIME = 60000L;
    public static final int MAX_MESSAGE_LENGTH = 0x500000;
    public static volatile P2pConfig p2pConfig;
    public static volatile List<P2pEventHandler> handlerList;
    public static volatile Map<Byte, P2pEventHandler> handlerMap;

    public static void addP2pEventHandle(P2pEventHandler p2PEventHandler) throws P2pException {
        if (p2PEventHandler.getMessageTypes() != null) {
            for (Byte type : p2PEventHandler.getMessageTypes()) {
                if (handlerMap.get(type) == null) continue;
                throw new P2pException(P2pException.TypeEnum.TYPE_ALREADY_REGISTERED, "type:" + type);
            }
            for (Byte type : p2PEventHandler.getMessageTypes()) {
                handlerMap.put(type, p2PEventHandler);
            }
        }
        handlerList.add(p2PEventHandler);
    }

    public static Discover.Endpoint getHomeNode() {
        Discover.Endpoint.Builder builder = Discover.Endpoint.newBuilder().setNodeId(ByteString.copyFrom((byte[])p2pConfig.getNodeID())).setPort(p2pConfig.getPort());
        if (StringUtils.isNotEmpty((CharSequence)p2pConfig.getIp())) {
            builder.setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(p2pConfig.getIp())));
        }
        if (StringUtils.isNotEmpty((CharSequence)p2pConfig.getIpv6())) {
            builder.setAddressIpv6(ByteString.copyFrom((byte[])ByteArray.fromString(p2pConfig.getIpv6())));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Parameter()";
    }

    static {
        handlerList = new ArrayList<P2pEventHandler>();
        handlerMap = new HashMap<Byte, P2pEventHandler>();
    }
}

