/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins.utils.db;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.plugins.utils.DBUtils;
import org.tron.plugins.utils.FileUtils;
import org.tron.plugins.utils.db.DBInterface;
import org.tron.plugins.utils.db.LevelDBImpl;
import org.tron.plugins.utils.db.RocksDBImpl;

public class DbTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"tool");
    private static final String KEY_ENGINE = "ENGINE";
    private static final String ENGINE_FILE = "engine.properties";
    private static final String FILE_SEPARATOR = File.separator;
    private static final String ROCKSDB = "ROCKSDB";
    private static final Map<String, DBInterface> dbMap = Maps.newConcurrentMap();

    public static DBInterface getDB(String sourceDir, String dbName) throws IOException, RocksDBException {
        DbType type = DbTool.getDbType(sourceDir, dbName);
        return DbTool.getDB(sourceDir, dbName, type);
    }

    public static DBInterface getDB(String sourceDir, String destDir, String dbName) throws IOException, RocksDBException {
        DbType type = DbTool.getDbType(sourceDir, dbName);
        return DbTool.getDB(destDir, dbName, type);
    }

    public static DBInterface getDB(String sourceDir, String dbName, DbType type) throws IOException, RocksDBException {
        DBInterface db;
        Path path = Paths.get(sourceDir, dbName);
        if (dbMap.containsKey(path.toString())) {
            return dbMap.get(path.toString());
        }
        switch (type) {
            case LevelDB: {
                db = DbTool.openLevelDb(path);
                dbMap.put(path.toString(), db);
                break;
            }
            case RocksDB: {
                db = DbTool.openRocksDb(path);
                dbMap.put(path.toString(), db);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
        return db;
    }

    public static DBInterface getDB(Path sourceDir, String dbName) throws IOException, RocksDBException {
        Path path = Paths.get(sourceDir.toString(), dbName);
        DbType type = DbTool.getDbType(sourceDir.toString(), dbName);
        switch (type) {
            case LevelDB: {
                return DbTool.openLevelDb(path);
            }
            case RocksDB: {
                return DbTool.openRocksDb(path);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }

    public static void closeDB(String sourceDir, String dbName) throws IOException {
        Path path = Paths.get(sourceDir, dbName);
        DBInterface db = dbMap.get(path.toString());
        if (db != null) {
            try {
                dbMap.remove(path.toString());
                db.close();
            }
            catch (IOException e) {
                logger.error("close db {} error: {}", (Object)path, (Object)e);
                throw e;
            }
        }
    }

    public static void close() {
        Iterator<Map.Entry<String, DBInterface>> iterator = dbMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DBInterface> next = iterator.next();
            try {
                next.getValue().close();
            }
            catch (IOException e) {
                logger.error("close db failed, db: {}", (Object)next.getKey(), (Object)e);
            }
            iterator.remove();
        }
    }

    private static DbType getDbType(String sourceDir, String dbName) {
        String engineFile = String.format("%s%s%s%s%s", sourceDir, FILE_SEPARATOR, dbName, FILE_SEPARATOR, ENGINE_FILE);
        if (!new File(engineFile).exists()) {
            return DbType.LevelDB;
        }
        String engine = FileUtils.readProperty(engineFile, KEY_ENGINE);
        if (engine.equalsIgnoreCase(ROCKSDB)) {
            return DbType.RocksDB;
        }
        return DbType.LevelDB;
    }

    private static LevelDBImpl openLevelDb(Path db) throws IOException {
        return new LevelDBImpl(DBUtils.newLevelDb(db));
    }

    private static RocksDBImpl openRocksDb(Path db) throws RocksDBException {
        return new RocksDBImpl(DBUtils.newRocksDb(db));
    }

    static enum DbType {
        LevelDB,
        RocksDB;

    }
}

