/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static boolean isLevelDBEngine(Path path) {
        String dir = path.toString();
        String enginePath = dir + File.separator + "engine.properties";
        if (!new File(enginePath).exists() && !FileUtils.writeProperty(enginePath, "ENGINE", "LEVELDB")) {
            return false;
        }
        String engine = FileUtils.readProperty(enginePath, "ENGINE");
        return "LEVELDB".equals(engine);
    }

    /*
     * Exception decompiling
     */
    public static String readProperty(String file, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean writeProperty(String file, String key, String value) {
        try (FileOutputStream o = new FileOutputStream(file);
             FileInputStream f = new FileInputStream(file);
             BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)o, StandardCharsets.UTF_8));
             BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)f, StandardCharsets.UTF_8));){
            Properties properties = new Properties();
            properties.load(r);
            properties.setProperty(key, value);
            properties.store(w, "Generated by the application.  PLEASE DO NOT EDIT! ");
        }
        catch (Exception e) {
            logger.warn("writeProperty", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean createFileIfNotExists(String filepath) {
        File file = new File(filepath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean createDirIfNotExists(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static boolean isExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean isSymbolicLink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static void copyDatabases(Path src, Path dest, List<String> subDirs) throws IOException {
        subDirs.forEach(dir -> {
            if (FileUtils.isExists(Paths.get(src.toString(), dir).toString())) {
                try {
                    Files.walk(Paths.get(src.toString(), dir), FileVisitOption.FOLLOW_LINKS).forEach(source -> FileUtils.copy(source, dest.resolve(src.relativize((Path)source))));
                }
                catch (IOException e) {
                    logger.error("copy database failed, src: {}, dest: {}, error: {}", new Object[]{Paths.get(src.toString(), dir), Paths.get(dest.toString(), dir), e.getMessage()});
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void copyDir(Path src, Path dest, String dir) {
        if (FileUtils.isExists(Paths.get(src.toString(), dir).toString())) {
            try {
                if (!FileUtils.createDirIfNotExists(Paths.get(dest.toString(), dir).toString())) {
                    throw new IOException(String.format("dest %s create fail ", Paths.get(dest.toString(), dir)));
                }
                Files.walk(Paths.get(src.toString(), dir), FileVisitOption.FOLLOW_LINKS).forEach(source -> FileUtils.copy(source, dest.resolve(src.relativize((Path)source))));
            }
            catch (IOException e) {
                logger.error("copy dir failed, src: {}, dest: {}, error: {}", new Object[]{Paths.get(src.toString(), dir), Paths.get(dest.toString(), dir), e.getMessage()});
                throw new RuntimeException(e);
            }
        }
    }

    public static void copy(Path source, Path dest) {
        try {
            if (source.toString().endsWith(".sst")) {
                try {
                    Files.createLink(dest, source);
                }
                catch (FileSystemException e) {
                    Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

