/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins.utils;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.Options;
import org.rocksdb.AbstractComparator;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.Filter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;
import org.tron.plugins.comparator.MarketOrderPriceComparatorForLevelDB;
import org.tron.plugins.comparator.MarketOrderPriceComparatorForRockDB;
import org.tron.plugins.utils.Sha256Hash;
import org.tron.protos.Protocol;

public class DBUtils {
    public static final String SPLIT_BLOCK_NUM = "split_block_num";
    public static final String MARKET_PAIR_PRICE_TO_ORDER = "market_pair_price_to_order";
    public static final String CHECKPOINT_DB_V2 = "checkpoint";
    public static final String TMP = "tmp";
    public static final int NODE_TYPE_LIGHT_NODE = 1;
    public static final String KEY_ENGINE = "ENGINE";
    public static final String FILE_ENGINE = "engine.properties";
    public static final String LEVELDB = "LEVELDB";
    public static final String ROCKSDB = "ROCKSDB";

    public static DB newLevelDb(Path db) throws IOException {
        File file = db.toFile();
        Options dbOptions = DBUtils.newDefaultLevelDbOptions();
        if (MARKET_PAIR_PRICE_TO_ORDER.equalsIgnoreCase(file.getName())) {
            dbOptions.comparator((DBComparator)new MarketOrderPriceComparatorForLevelDB());
        }
        return JniDBFactory.factory.open(file, dbOptions);
    }

    public static Options newDefaultLevelDbOptions() {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(CompressionType.SNAPPY);
        dbOptions.blockSize(4096);
        dbOptions.writeBufferSize(0xA00000);
        dbOptions.cacheSize(0xA00000L);
        dbOptions.maxOpenFiles(1000);
        return dbOptions;
    }

    private static org.rocksdb.Options newDefaultRocksDbOptions(boolean forBulkLoad) {
        org.rocksdb.Options options = new org.rocksdb.Options();
        options.setCreateIfMissing(true);
        options.setIncreaseParallelism(1);
        options.setNumLevels(7);
        options.setMaxOpenFiles(5000);
        options.setTargetFileSizeBase(0x4000000L);
        options.setTargetFileSizeMultiplier(1);
        options.setMaxBytesForLevelBase(0x20000000L);
        options.setMaxBackgroundCompactions(Math.max(1, Runtime.getRuntime().availableProcessors()));
        options.setLevel0FileNumCompactionTrigger(4);
        options.setLevelCompactionDynamicLevelBytes(true);
        BlockBasedTableConfig tableCfg = new BlockBasedTableConfig();
        options.setTableFormatConfig((TableFormatConfig)tableCfg);
        tableCfg.setBlockSize(65536L);
        tableCfg.setBlockCacheSize(0x2000000L);
        tableCfg.setCacheIndexAndFilterBlocks(true);
        tableCfg.setPinL0FilterAndIndexBlocksInCache(true);
        tableCfg.setFilter((Filter)new BloomFilter(10, false));
        if (forBulkLoad) {
            options.prepareForBulkLoad();
        }
        return options;
    }

    public static RocksDB newRocksDb(Path db) throws RocksDBException {
        try (org.rocksdb.Options options = DBUtils.newDefaultRocksDbOptions(false);){
            if (MARKET_PAIR_PRICE_TO_ORDER.equalsIgnoreCase(db.getFileName().toString())) {
                options.setComparator((AbstractComparator)new MarketOrderPriceComparatorForRockDB(new ComparatorOptions()));
            }
            RocksDB rocksDB = RocksDB.open((org.rocksdb.Options)options, (String)db.toString());
            return rocksDB;
        }
    }

    public static RocksDB newRocksDbForBulkLoad(Path db) throws RocksDBException {
        try (org.rocksdb.Options options = DBUtils.newDefaultRocksDbOptions(true);){
            if (MARKET_PAIR_PRICE_TO_ORDER.equalsIgnoreCase(db.getFileName().toString())) {
                options.setComparator((AbstractComparator)new MarketOrderPriceComparatorForRockDB(new ComparatorOptions()));
            }
            RocksDB rocksDB = RocksDB.open((org.rocksdb.Options)options, (String)db.toString());
            return rocksDB;
        }
    }

    public static RocksDB newRocksDbReadOnly(Path db) throws RocksDBException {
        try (org.rocksdb.Options options = DBUtils.newDefaultRocksDbOptions(false);){
            if (MARKET_PAIR_PRICE_TO_ORDER.equalsIgnoreCase(db.getFileName().toString())) {
                options.setComparator((AbstractComparator)new MarketOrderPriceComparatorForRockDB(new ComparatorOptions()));
            }
            RocksDB rocksDB = RocksDB.openReadOnly((org.rocksdb.Options)options, (String)db.toString());
            return rocksDB;
        }
    }

    public static String simpleDecode(byte[] bytes) {
        byte[] lengthBytes = Arrays.copyOf(bytes, 4);
        int length = Ints.fromByteArray((byte[])lengthBytes);
        byte[] value = Arrays.copyOfRange(bytes, 4, 4 + length);
        return new String(value);
    }

    public static Sha256Hash getTransactionId(Protocol.Transaction transaction) {
        return Sha256Hash.of(true, transaction.getRawData().toByteArray());
    }

    public static enum Operator {
        CREATE(0),
        MODIFY(1),
        DELETE(2),
        PUT(3);

        private byte value;

        private Operator(byte value) {
            this.value = value;
        }

        static Operator valueOf(byte b) {
            switch (b) {
                case 0: {
                    return CREATE;
                }
                case 1: {
                    return MODIFY;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return PUT;
                }
            }
            return null;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

