/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import org.tron.common.crypto.zksnark.Field;

public abstract class BN128<T extends Field<T>> {
    protected T x;
    protected T y;
    protected T z;

    protected BN128(T x, T y, T z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    protected abstract BN128<T> zero();

    protected abstract BN128<T> instance(T var1, T var2, T var3);

    protected abstract T b();

    protected abstract T one();

    public BN128<T> toAffine() {
        if (this.isZero()) {
            BN128<T> zero = this.zero();
            return this.instance(zero.x, this.one(), zero.z);
        }
        Field zInv = (Field)this.z.inverse();
        Field zInv2 = (Field)zInv.squared();
        Field zInv3 = zInv2.mul(zInv);
        Field ax = this.x.mul((Field)zInv2);
        Field ay = this.y.mul((Field)zInv3);
        return this.instance(ax, ay, this.one());
    }

    public BN128<T> toEthNotation() {
        BN128<T> affine = this.toAffine();
        if (affine.isZero()) {
            return this.zero();
        }
        return affine;
    }

    protected boolean isOnCurve() {
        if (this.isZero()) {
            return true;
        }
        Field z6 = (Field)((Field)((Field)this.z.squared()).mul(this.z)).squared();
        Field left = (Field)this.y.squared();
        Field right = ((Field)((Field)this.x.squared()).mul(this.x)).add(this.b().mul((Field)z6));
        return left.equals(right);
    }

    public BN128<T> add(BN128<T> o) {
        if (this.isZero()) {
            return o;
        }
        if (o.isZero()) {
            return this;
        }
        Field x1 = this.x;
        Field y1 = this.y;
        Field z1 = this.z;
        Field x2 = o.x;
        Field y2 = o.y;
        Field z2 = o.z;
        Field z1z1 = (Field)z1.squared();
        Field z2z2 = (Field)z2.squared();
        Field u1 = x1.mul((Field)z2z2);
        Field u2 = x2.mul((Field)z1z1);
        Field z1Cubed = z1.mul((Field)z1z1);
        Field z2Cubed = z2.mul((Field)z2z2);
        Field s1 = y1.mul((Field)z2Cubed);
        Field s2 = y2.mul((Field)z1Cubed);
        if (u1.equals(u2) && s1.equals(s2)) {
            return this.dbl();
        }
        Field h = u2.sub(u1);
        Field i = (Field)((Field)h.dbl()).squared();
        Field j = h.mul(i);
        Field r = (Field)s2.sub(s1).dbl();
        Field v = u1.mul(i);
        Field zz = (Field)((Field)((Field)((Field)z1.add(z2)).squared()).sub(z1.squared())).sub(z2.squared());
        Field x3 = (Field)((Field)r.squared()).sub(j).sub(v.dbl());
        Field y3 = (Field)v.sub(x3).mul(r).sub(s1.mul(j).dbl());
        Field z3 = zz.mul(h);
        return this.instance(x3, y3, z3);
    }

    public BN128<T> mul(BigInteger s) {
        if (s.compareTo(BigInteger.ZERO) == 0) {
            return this.zero();
        }
        if (this.isZero()) {
            return this;
        }
        BN128<T> res = this.zero();
        for (int i = s.bitLength() - 1; i >= 0; --i) {
            res = super.dbl();
            if (!s.testBit(i)) continue;
            res = res.add(this);
        }
        return res;
    }

    private BN128<T> dbl() {
        if (this.isZero()) {
            return this;
        }
        Field a = (Field)this.x.squared();
        Field b = (Field)this.y.squared();
        Field c = (Field)b.squared();
        Field d = ((Field)this.x.add((Field)b).squared()).sub(a).sub(c);
        d = d.add(d);
        Field e = a.add(a).add(a);
        Field f = (Field)e.squared();
        Field x3 = f.sub(d.add(d));
        Field y3 = (Field)e.mul(d.sub(x3)).sub(((Field)((Field)c.dbl()).dbl()).dbl());
        Field z3 = (Field)((Field)this.y.mul(this.z)).dbl();
        return this.instance(x3, y3, z3);
    }

    public T x() {
        return this.x;
    }

    public T y() {
        return this.y;
    }

    public boolean isZero() {
        return this.z.isZero();
    }

    protected boolean isValid() {
        if (!(this.x.isValid() && this.y.isValid() && this.z.isValid())) {
            return false;
        }
        return this.isOnCurve();
    }

    public String toString() {
        return String.format("(%s; %s; %s)", this.x.toString(), this.y.toString(), this.z.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BN128)) {
            return false;
        }
        BN128 bn128 = (BN128)o;
        if (this.x != null ? !this.x.equals(bn128.x) : bn128.x != null) {
            return false;
        }
        if (this.y != null ? !this.y.equals(bn128.y) : bn128.y != null) {
            return false;
        }
        return !(this.z == null ? bn128.z != null : !this.z.equals(bn128.z));
    }
}

