/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.sm2;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.Hash;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignatureInterface;
import org.tron.common.crypto.jce.ECKeyFactory;
import org.tron.common.crypto.jce.TronCastleProvider;
import org.tron.common.crypto.sm2.SM2Signer;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteUtil;

public class SM2
implements Serializable,
SignInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"crypto");
    private static BigInteger SM2_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger SM2_P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger SM2_A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger SM2_B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger SM2_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger SM2_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_param;
    private static ECParameterSpec ecc_spec;
    private static ECCurve.Fp curve;
    private static org.bouncycastle.math.ec.ECPoint ecc_point_g;
    private static final SecureRandom secureRandom;
    protected final org.bouncycastle.math.ec.ECPoint pub;
    private final PrivateKey privKey;
    private transient byte[] pubKeyHash;
    private transient byte[] nodeId;

    public SM2() {
        this(secureRandom);
    }

    public SM2(SecureRandom secureRandom) {
        ECKeyGenerationParameters ecKeyGenerationParameters = new ECKeyGenerationParameters(ecc_param, secureRandom);
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)ecKeyGenerationParameters);
        AsymmetricCipherKeyPair kp = keyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)kp.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)kp.getPublic();
        BigInteger privateKey = ecpriv.getD();
        this.privKey = SM2.privateKeyFromBigInteger(privateKey);
        this.pub = ecpub.getQ();
    }

    public SM2(byte[] key, boolean isPrivateKey) {
        if (isPrivateKey) {
            BigInteger pk = new BigInteger(1, key);
            this.privKey = SM2.privateKeyFromBigInteger(pk);
            this.pub = ecc_param.getG().multiply(pk);
        } else {
            this.privKey = null;
            this.pub = ecc_param.getCurve().decodePoint(key);
        }
    }

    public SM2(@Nullable PrivateKey privKey, org.bouncycastle.math.ec.ECPoint pub) {
        if (privKey != null && !SM2.isECPrivateKey(privKey)) {
            throw new IllegalArgumentException("Expected EC private key, given a private key object with class " + privKey.getClass().toString() + " and algorithm " + privKey.getAlgorithm());
        }
        this.privKey = privKey;
        if (pub == null) {
            throw new IllegalArgumentException("Public key may not be null");
        }
        this.pub = pub;
    }

    public SM2(@Nullable BigInteger priv, org.bouncycastle.math.ec.ECPoint pub) {
        this(SM2.privateKeyFromBigInteger(priv), pub);
    }

    private static PrivateKey privateKeyFromBigInteger(BigInteger priv) {
        if (priv == null) {
            return null;
        }
        try {
            return ECKeyFactory.getInstance(TronCastleProvider.getInstance()).generatePrivate((KeySpec)new ECPrivateKeySpec(priv, ecc_spec));
        }
        catch (InvalidKeySpecException ex) {
            throw new AssertionError((Object)"Assumed correct key spec statically");
        }
    }

    private static boolean isECPrivateKey(PrivateKey privKey) {
        return privKey instanceof ECPrivateKey || privKey.getAlgorithm().equals("EC");
    }

    private static org.bouncycastle.math.ec.ECPoint extractPublicKey(ECPublicKey ecPublicKey) {
        ECPoint publicPointW = ecPublicKey.getW();
        BigInteger xCoord = publicPointW.getAffineX();
        BigInteger yCoord = publicPointW.getAffineY();
        return ecc_param.getCurve().createPoint(xCoord, yCoord);
    }

    public static org.bouncycastle.math.ec.ECPoint compressPoint(org.bouncycastle.math.ec.ECPoint uncompressed) {
        return ecc_param.getCurve().decodePoint(uncompressed.getEncoded(true));
    }

    public static org.bouncycastle.math.ec.ECPoint decompressPoint(org.bouncycastle.math.ec.ECPoint compressed) {
        return ecc_param.getCurve().decodePoint(compressed.getEncoded(false));
    }

    public static SM2 fromPrivate(BigInteger privKey) {
        return new SM2(privKey, ecc_param.getG().multiply(privKey));
    }

    public static SM2 fromPrivate(byte[] privKeyBytes) {
        if (Objects.isNull(privKeyBytes)) {
            return null;
        }
        return SM2.fromPrivate(new BigInteger(1, privKeyBytes));
    }

    public static SM2 fromPrivateAndPrecalculatedPublic(BigInteger priv, org.bouncycastle.math.ec.ECPoint pub) {
        return new SM2(priv, pub);
    }

    public static SM2 fromPrivateAndPrecalculatedPublic(byte[] priv, byte[] pub) {
        SM2.check(priv != null, "Private key must not be null");
        SM2.check(pub != null, "Public key must not be null");
        return new SM2(new BigInteger(1, priv), ecc_param.getCurve().decodePoint(pub));
    }

    public static SM2 fromPublicOnly(org.bouncycastle.math.ec.ECPoint pub) {
        return new SM2((PrivateKey)null, pub);
    }

    public static SM2 fromPublicOnly(byte[] pub) {
        return new SM2((PrivateKey)null, ecc_param.getCurve().decodePoint(pub));
    }

    public static byte[] publicKeyFromPrivate(BigInteger privKey, boolean compressed) {
        org.bouncycastle.math.ec.ECPoint point = ecc_param.getG().multiply(privKey);
        return point.getEncoded(compressed);
    }

    public static byte[] pubBytesWithoutFormat(org.bouncycastle.math.ec.ECPoint pubPoint) {
        byte[] pubBytes = pubPoint.getEncoded(false);
        return Arrays.copyOfRange(pubBytes, 1, pubBytes.length);
    }

    public static SM2 fromNodeId(byte[] nodeId) {
        SM2.check(nodeId.length == 64, "Expected a 64 byte node id");
        byte[] pubBytes = new byte[65];
        System.arraycopy(nodeId, 0, pubBytes, 1, nodeId.length);
        pubBytes[0] = 4;
        return SM2.fromPublicOnly(pubBytes);
    }

    public static byte[] signatureToKeyBytes(byte[] messageHash, String signatureBase64) throws SignatureException {
        byte[] signatureEncoded;
        try {
            signatureEncoded = Base64.decode((String)signatureBase64);
        }
        catch (RuntimeException e) {
            throw new SignatureException("Could not decode base64", e);
        }
        if (signatureEncoded.length < 65) {
            throw new SignatureException("Signature truncated, expected 65 bytes and got " + signatureEncoded.length);
        }
        return SM2.signatureToKeyBytes(messageHash, SM2Signature.fromComponents(Arrays.copyOfRange(signatureEncoded, 1, 33), Arrays.copyOfRange(signatureEncoded, 33, 65), (byte)(signatureEncoded[0] & 0xFF)));
    }

    public static byte[] signatureToKeyBytes(byte[] messageHash, SM2Signature sig) throws SignatureException {
        int recId;
        byte[] key;
        SM2.check(messageHash.length == 32, "messageHash argument has length " + messageHash.length);
        int header = sig.v;
        if (header < 27 || header > 34) {
            throw new SignatureException("Header byte out of range: " + header);
        }
        if (header >= 31) {
            header -= 4;
        }
        if ((key = SM2.recoverPubBytesFromSignature(recId = header - 27, sig, messageHash)) == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return key;
    }

    public byte[] hash(byte[] message) {
        SM2Signer signer = this.getSM2SignerForHash();
        return signer.generateSM3Hash(message);
    }

    @Override
    public byte[] getPrivateKey() {
        return this.getPrivKeyBytes();
    }

    @Override
    public byte[] getPubKey() {
        return this.pub.getEncoded(false);
    }

    @Override
    public byte[] getAddress() {
        if (this.pubKeyHash == null) {
            this.pubKeyHash = Hash.computeAddress(this.pub);
        }
        return this.pubKeyHash;
    }

    public static byte[] signatureToAddress(byte[] messageHash, String signatureBase64) throws SignatureException {
        return Hash.computeAddress(SM2.signatureToKeyBytes(messageHash, signatureBase64));
    }

    public static byte[] signatureToAddress(byte[] messageHash, SM2Signature sig) throws SignatureException {
        return Hash.computeAddress(SM2.signatureToKeyBytes(messageHash, sig));
    }

    public static SM2 signatureToKey(byte[] messageHash, String signatureBase64) throws SignatureException {
        byte[] keyBytes = SM2.signatureToKeyBytes(messageHash, signatureBase64);
        return SM2.fromPublicOnly(keyBytes);
    }

    public static SM2 signatureToKey(byte[] messageHash, SM2Signature sig) throws SignatureException {
        byte[] keyBytes = SM2.signatureToKeyBytes(messageHash, sig);
        return SM2.fromPublicOnly(keyBytes);
    }

    public SM2Signature sign(byte[] messageHash) {
        if (messageHash.length != 32) {
            throw new IllegalArgumentException("Expected 32 byte input to SM2 signature, not " + messageHash.length);
        }
        SM2Signer signer = this.getSigner();
        BigInteger[] componets = signer.generateHashSignature(messageHash);
        SM2Signature sig = new SM2Signature(componets[0], componets[1]);
        int recId = -1;
        byte[] thisKey = this.pub.getEncoded(false);
        for (int i = 0; i < 4; ++i) {
            byte[] k = SM2.recoverPubBytesFromSignature(i, sig, messageHash);
            if (k == null || !Arrays.equals(k, thisKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        sig.v = (byte)(recId + 27);
        return sig;
    }

    @Override
    public String signHash(byte[] input) {
        return this.sign(input).toBase64();
    }

    @Override
    public byte[] Base64toBytes(String signature) {
        byte[] signData = Base64.decode((String)signature);
        byte first = (byte)(signData[0] - 27);
        byte[] temp = Arrays.copyOfRange(signData, 1, 65);
        return ByteUtil.appendByte((byte[])temp, (byte)first);
    }

    public SM2Signature signMessage(byte[] message, @Nullable String userID) {
        SM2Signature sig = this.signMsg(message, userID);
        int recId = -1;
        byte[] thisKey = this.pub.getEncoded(false);
        SM2Signer signer = this.getSigner();
        byte[] messageHash = signer.generateSM3Hash(message);
        for (int i = 0; i < 4; ++i) {
            byte[] k = SM2.recoverPubBytesFromSignature(i, sig, messageHash);
            if (k == null || !Arrays.equals(k, thisKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        sig.v = (byte)(recId + 27);
        return sig;
    }

    public SM2Signature signMsg(byte[] msg, @Nullable String userID) {
        if (null == msg) {
            throw new IllegalArgumentException("Expected signature message of SM2 is null");
        }
        SM2Signer signer = this.getSigner();
        BigInteger[] componets = signer.generateSignature(msg);
        return new SM2Signature(componets[0], componets[1]);
    }

    private SM2Signer getSigner() {
        SM2Signer signer = new SM2Signer();
        BigInteger d = this.getPrivKey();
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(d, ecc_param);
        signer.init(true, (CipherParameters)privateKeyParameters);
        return signer;
    }

    public SM2Signer getSM2SignerForHash() {
        SM2Signer signer = new SM2Signer();
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(this.pub, ecc_param);
        signer.init(false, (CipherParameters)publicKeyParameters);
        return signer;
    }

    @Nullable
    public static byte[] recoverPubBytesFromSignature(int recId, SM2Signature sig, byte[] messageHash) {
        SM2.check(recId >= 0, "recId must be positive");
        SM2.check(sig.r.signum() >= 0, "r must be positive");
        SM2.check(sig.s.signum() >= 0, "s must be positive");
        SM2.check(messageHash != null, "messageHash must not be null");
        BigInteger n = ecc_param.getN();
        BigInteger prime = curve.getQ();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger e = new BigInteger(1, messageHash);
        BigInteger x = sig.r.subtract(e).mod(n);
        x = x.add(i.multiply(n));
        ECCurve.Fp curve = (ECCurve.Fp)ecc_param.getCurve();
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        org.bouncycastle.math.ec.ECPoint R = SM2.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger srInv = sig.s.add(sig.r).modInverse(n);
        BigInteger sNeg = BigInteger.ZERO.subtract(sig.s).mod(n);
        BigInteger coeff = srInv.multiply(sNeg).mod(n);
        ECPoint.Fp q = (ECPoint.Fp)ECAlgorithms.sumOfTwoMultiplies((org.bouncycastle.math.ec.ECPoint)ecc_param.getG(), (BigInteger)coeff, (org.bouncycastle.math.ec.ECPoint)R, (BigInteger)srInv);
        return q.getEncoded(false);
    }

    private static org.bouncycastle.math.ec.ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(ecc_param.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return ecc_param.getCurve().decodePoint(compEnc);
    }

    private static void check(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean verify(byte[] data, SM2Signature signature, byte[] pub) {
        SM2Signer signer = new SM2Signer();
        ECPublicKeyParameters params = new ECPublicKeyParameters(ecc_param.getCurve().decodePoint(pub), ecc_param);
        signer.init(false, (CipherParameters)params);
        try {
            return signer.verifyHashSignature(data, signature.r, signature.s);
        }
        catch (NullPointerException npe) {
            logger.error("Caught NPE inside bouncy castle", (Throwable)npe);
            return false;
        }
    }

    public static boolean verify(byte[] data, byte[] signature, byte[] pub) {
        return SM2.verify(data, SM2Signature.decodeFromDER(signature), pub);
    }

    public static boolean verifyMessage(byte[] msg, SM2Signature signature, byte[] pub, @Nullable String userID) {
        SM2Signer signer = new SM2Signer();
        ECPublicKeyParameters params = new ECPublicKeyParameters(ecc_param.getCurve().decodePoint(pub), ecc_param);
        signer.init(false, (CipherParameters)params);
        try {
            return signer.verifySignature(msg, signature.r, signature.s, userID);
        }
        catch (NullPointerException npe) {
            logger.error("Caught NPE inside bouncy castle", (Throwable)npe);
            return false;
        }
    }

    public static boolean verifyMessage(byte[] msg, byte[] signature, byte[] pub, @Nullable String userID) {
        return SM2.verifyMessage(msg, SM2Signature.decodeFromDER(signature), pub, userID);
    }

    public static boolean isPubKeyCanonical(byte[] pubkey) {
        if (pubkey[0] == 4) {
            return pubkey.length == 65;
        }
        if (pubkey[0] == 2 || pubkey[0] == 3) {
            return pubkey.length == 33;
        }
        return false;
    }

    @Nullable
    public static byte[] recoverAddressFromSignature(int recId, SM2Signature sig, byte[] messageHash) {
        byte[] pubBytes = SM2.recoverPubBytesFromSignature(recId, sig, messageHash);
        if (pubBytes == null) {
            return null;
        }
        return Hash.computeAddress(pubBytes);
    }

    @Nullable
    public static SM2 recoverFromSignature(int recId, SM2Signature sig, byte[] messageHash) {
        byte[] pubBytes = SM2.recoverPubBytesFromSignature(recId, sig, messageHash);
        if (pubBytes == null) {
            return null;
        }
        return SM2.fromPublicOnly(pubBytes);
    }

    public boolean isPubKeyOnly() {
        return this.privKey == null;
    }

    public boolean hasPrivKey() {
        return this.privKey != null;
    }

    @Override
    public byte[] getNodeId() {
        if (this.nodeId == null) {
            this.nodeId = SM2.pubBytesWithoutFormat(this.pub);
        }
        return this.nodeId;
    }

    public org.bouncycastle.math.ec.ECPoint getPubKeyPoint() {
        return this.pub;
    }

    public BigInteger getPrivKey() {
        if (this.privKey == null) {
            throw new ECKey.MissingPrivateKeyException();
        }
        if (this.privKey instanceof BCECPrivateKey) {
            return ((BCECPrivateKey)this.privKey).getD();
        }
        throw new ECKey.MissingPrivateKeyException();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("pub:").append(Hex.toHexString((byte[])this.pub.getEncoded(false)));
        return b.toString();
    }

    public String toStringWithPrivate() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        if (this.privKey != null && this.privKey instanceof BCECPrivateKey) {
            b.append(" priv:").append(Hex.toHexString((byte[])((BCECPrivateKey)this.privKey).getD().toByteArray()));
        }
        return b.toString();
    }

    public boolean verify(byte[] data, byte[] signature) {
        return SM2.verify(data, signature, this.getPubKey());
    }

    public boolean verify(byte[] sigHash, SM2Signature signature) {
        return SM2.verify(sigHash, signature, this.getPubKey());
    }

    public boolean isPubKeyCanonical() {
        return SM2.isPubKeyCanonical(this.pub.getEncoded(false));
    }

    @Nullable
    public byte[] getPrivKeyBytes() {
        if (this.privKey == null) {
            return null;
        }
        if (this.privKey instanceof BCECPrivateKey) {
            return ByteUtil.bigIntegerToBytes((BigInteger)((BCECPrivateKey)this.privKey).getD(), (int)32);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM2 ecKey = (SM2)o;
        if (this.privKey != null && !this.privKey.equals(ecKey.privKey)) {
            return false;
        }
        return this.pub == null || this.pub.equals(ecKey.pub);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getPubKey());
    }

    static {
        secureRandom = new SecureRandom();
        curve = new ECCurve.Fp(SM2_P, SM2_A, SM2_B, null, null);
        ecc_point_g = curve.createPoint(SM2_GX, SM2_GY);
        ecc_param = new ECDomainParameters((ECCurve)curve, ecc_point_g, SM2_N);
        ecc_spec = new ECParameterSpec((ECCurve)curve, ecc_point_g, SM2_N);
    }

    public static class SM2Signature
    implements SignatureInterface {
        public final BigInteger r;
        public final BigInteger s;
        public byte v;

        public SM2Signature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public SM2Signature(byte[] r, byte[] s, byte v) {
            this.r = new BigInteger(1, r);
            this.s = new BigInteger(1, s);
            this.v = v;
        }

        private static SM2Signature fromComponents(byte[] r, byte[] s) {
            return new SM2Signature(new BigInteger(1, r), new BigInteger(1, s));
        }

        public static SM2Signature fromComponents(byte[] r, byte[] s, byte v) {
            SM2Signature signature = SM2Signature.fromComponents(r, s);
            signature.v = v;
            return signature;
        }

        public static boolean validateComponents(BigInteger r, BigInteger s, byte v) {
            if (v != 27 && v != 28) {
                return false;
            }
            if (BIUtil.isLessThan((BigInteger)r, (BigInteger)BigInteger.ONE)) {
                return false;
            }
            if (BIUtil.isLessThan((BigInteger)s, (BigInteger)BigInteger.ONE)) {
                return false;
            }
            if (!BIUtil.isLessThan((BigInteger)r, (BigInteger)SM2_N)) {
                return false;
            }
            return BIUtil.isLessThan((BigInteger)s, (BigInteger)SM2_N);
        }

        public static SM2Signature decodeFromDER(byte[] bytes) {
            ASN1InputStream decoder = null;
            try {
                ASN1Integer s;
                ASN1Integer r;
                decoder = new ASN1InputStream(bytes);
                DLSequence seq = (DLSequence)decoder.readObject();
                if (seq == null) {
                    throw new RuntimeException("Reached past end of ASN.1 stream.");
                }
                try {
                    r = (ASN1Integer)seq.getObjectAt(0);
                    s = (ASN1Integer)seq.getObjectAt(1);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(e);
                }
                SM2Signature sM2Signature = new SM2Signature(r.getPositiveValue(), s.getPositiveValue());
                return sM2Signature;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (decoder != null) {
                    try {
                        decoder.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public boolean validateComponents() {
            return SM2Signature.validateComponents(this.r, this.s, this.v);
        }

        public String toBase64() {
            byte[] sigData = new byte[65];
            sigData[0] = this.v;
            System.arraycopy(ByteUtil.bigIntegerToBytes((BigInteger)this.r, (int)32), 0, sigData, 1, 32);
            System.arraycopy(ByteUtil.bigIntegerToBytes((BigInteger)this.s, (int)32), 0, sigData, 33, 32);
            return new String(Base64.encode((byte[])sigData), Charset.forName("UTF-8"));
        }

        public byte[] toByteArray() {
            byte fixedV = this.v >= 27 ? (byte)(this.v - 27) : this.v;
            return ByteUtil.merge((byte[][])new byte[][]{ByteUtil.bigIntegerToBytes((BigInteger)this.r, (int)32), ByteUtil.bigIntegerToBytes((BigInteger)this.s, (int)32), {fixedV}});
        }

        public String toHex() {
            return Hex.toHexString((byte[])this.toByteArray());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SM2Signature signature = (SM2Signature)o;
            if (!this.r.equals(signature.r)) {
                return false;
            }
            return this.s.equals(signature.s);
        }

        public int hashCode() {
            int result = this.r.hashCode();
            result = 31 * result + this.s.hashCode();
            return result;
        }
    }
}

