/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.Hash;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignatureInterface;
import org.tron.common.crypto.jce.ECKeyFactory;
import org.tron.common.crypto.jce.ECKeyPairGenerator;
import org.tron.common.crypto.jce.TronCastleProvider;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteUtil;

public class ECKey
implements Serializable,
SignInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"crypto");
    public static final ECDomainParameters CURVE;
    public static final ECParameterSpec CURVE_SPEC;
    public static final BigInteger HALF_CURVE_ORDER;
    private static final BigInteger SECP256K1N;
    private static final SecureRandom secureRandom;
    private static final long serialVersionUID = -728224901792295832L;
    protected final org.bouncycastle.math.ec.ECPoint pub;
    private final PrivateKey privKey;
    private final Provider provider;
    private transient byte[] pubKeyHash;
    private transient byte[] nodeId;

    public ECKey() {
        this(secureRandom);
    }

    public ECKey(Provider provider, SecureRandom secureRandom) {
        this.provider = provider;
        KeyPairGenerator keyPairGen = ECKeyPairGenerator.getInstance(provider, secureRandom);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        this.privKey = keyPair.getPrivate();
        PublicKey pubKey = keyPair.getPublic();
        if (pubKey instanceof BCECPublicKey) {
            this.pub = ((BCECPublicKey)pubKey).getQ();
        } else if (pubKey instanceof ECPublicKey) {
            this.pub = ECKey.extractPublicKey((ECPublicKey)pubKey);
        } else {
            throw new AssertionError((Object)("Expected Provider " + provider.getName() + " to produce a subtype of ECPublicKey, found " + pubKey.getClass()));
        }
    }

    public ECKey(SecureRandom secureRandom) {
        this(TronCastleProvider.getInstance(), secureRandom);
    }

    public ECKey(byte[] key, boolean isPrivateKey) {
        if (isPrivateKey) {
            BigInteger pk = new BigInteger(1, key);
            this.privKey = ECKey.privateKeyFromBigInteger(pk);
            this.pub = CURVE.getG().multiply(pk);
        } else {
            this.privKey = null;
            this.pub = CURVE.getCurve().decodePoint(key);
        }
        this.provider = TronCastleProvider.getInstance();
    }

    public ECKey(Provider provider, @Nullable PrivateKey privKey, org.bouncycastle.math.ec.ECPoint pub) {
        this.provider = provider;
        if (privKey != null && !ECKey.isECPrivateKey(privKey)) {
            throw new IllegalArgumentException("Expected EC private key, given a private key object with class " + privKey.getClass().toString() + " and algorithm " + privKey.getAlgorithm());
        }
        this.privKey = privKey;
        if (pub == null) {
            throw new IllegalArgumentException("Public key may not be null");
        }
        this.pub = pub;
    }

    public ECKey(@Nullable BigInteger priv, org.bouncycastle.math.ec.ECPoint pub) {
        this(TronCastleProvider.getInstance(), ECKey.privateKeyFromBigInteger(priv), pub);
    }

    private static org.bouncycastle.math.ec.ECPoint extractPublicKey(ECPublicKey ecPublicKey) {
        ECPoint publicPointW = ecPublicKey.getW();
        BigInteger xCoord = publicPointW.getAffineX();
        BigInteger yCoord = publicPointW.getAffineY();
        return CURVE.getCurve().createPoint(xCoord, yCoord);
    }

    private static boolean isECPrivateKey(PrivateKey privKey) {
        return privKey instanceof ECPrivateKey || privKey.getAlgorithm().equals("EC");
    }

    private static PrivateKey privateKeyFromBigInteger(BigInteger priv) {
        if (priv == null) {
            return null;
        }
        try {
            return ECKeyFactory.getInstance(TronCastleProvider.getInstance()).generatePrivate((KeySpec)new ECPrivateKeySpec(priv, CURVE_SPEC));
        }
        catch (InvalidKeySpecException ex) {
            throw new AssertionError((Object)"Assumed correct key spec statically");
        }
    }

    public static org.bouncycastle.math.ec.ECPoint compressPoint(org.bouncycastle.math.ec.ECPoint uncompressed) {
        return CURVE.getCurve().decodePoint(uncompressed.getEncoded(true));
    }

    public static org.bouncycastle.math.ec.ECPoint decompressPoint(org.bouncycastle.math.ec.ECPoint compressed) {
        return CURVE.getCurve().decodePoint(compressed.getEncoded(false));
    }

    public static ECKey fromPrivate(BigInteger privKey) {
        return new ECKey(privKey, CURVE.getG().multiply(privKey));
    }

    public static ECKey fromPrivate(byte[] privKeyBytes) {
        if (Objects.isNull(privKeyBytes)) {
            return null;
        }
        return ECKey.fromPrivate(new BigInteger(1, privKeyBytes));
    }

    public static ECKey fromPrivateAndPrecalculatedPublic(BigInteger priv, org.bouncycastle.math.ec.ECPoint pub) {
        return new ECKey(priv, pub);
    }

    public static ECKey fromPrivateAndPrecalculatedPublic(byte[] priv, byte[] pub) {
        ECKey.check(priv != null, "Private key must not be null");
        ECKey.check(pub != null, "Public key must not be null");
        return new ECKey(new BigInteger(1, priv), CURVE.getCurve().decodePoint(pub));
    }

    public static ECKey fromPublicOnly(org.bouncycastle.math.ec.ECPoint pub) {
        return new ECKey(null, pub);
    }

    public static ECKey fromPublicOnly(byte[] pub) {
        return new ECKey(null, CURVE.getCurve().decodePoint(pub));
    }

    public static byte[] publicKeyFromPrivate(BigInteger privKey, boolean compressed) {
        org.bouncycastle.math.ec.ECPoint point = CURVE.getG().multiply(privKey);
        return point.getEncoded(compressed);
    }

    public static byte[] pubBytesWithoutFormat(org.bouncycastle.math.ec.ECPoint pubPoint) {
        byte[] pubBytes = pubPoint.getEncoded(false);
        return Arrays.copyOfRange(pubBytes, 1, pubBytes.length);
    }

    public static ECKey fromNodeId(byte[] nodeId) {
        ECKey.check(nodeId.length == 64, "Expected a 64 byte node id");
        byte[] pubBytes = new byte[65];
        System.arraycopy(nodeId, 0, pubBytes, 1, nodeId.length);
        pubBytes[0] = 4;
        return ECKey.fromPublicOnly(pubBytes);
    }

    public static byte[] signatureToKeyBytes(byte[] messageHash, String signatureBase64) throws SignatureException {
        byte[] signatureEncoded;
        try {
            signatureEncoded = Base64.decode((String)signatureBase64);
        }
        catch (RuntimeException e) {
            throw new SignatureException("Could not decode base64", e);
        }
        if (signatureEncoded.length < 65) {
            throw new SignatureException("Signature truncated, expected 65 bytes and got " + signatureEncoded.length);
        }
        return ECKey.signatureToKeyBytes(messageHash, ECDSASignature.fromComponents(Arrays.copyOfRange(signatureEncoded, 1, 33), Arrays.copyOfRange(signatureEncoded, 33, 65), (byte)(signatureEncoded[0] & 0xFF)));
    }

    public static byte[] signatureToKeyBytes(byte[] messageHash, ECDSASignature sig) throws SignatureException {
        int recId;
        byte[] key;
        ECKey.check(messageHash.length == 32, "messageHash argument has length " + messageHash.length);
        int header = sig.v;
        if (header < 27 || header > 34) {
            throw new SignatureException("Header byte out of range: " + header);
        }
        if (header >= 31) {
            header -= 4;
        }
        if ((key = ECKey.recoverPubBytesFromSignature(recId = header - 27, sig, messageHash)) == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return key;
    }

    public static byte[] signatureToAddress(byte[] messageHash, String signatureBase64) throws SignatureException {
        return Hash.computeAddress(ECKey.signatureToKeyBytes(messageHash, signatureBase64));
    }

    public static byte[] signatureToAddress(byte[] messageHash, ECDSASignature sig) throws SignatureException {
        return Hash.computeAddress(ECKey.signatureToKeyBytes(messageHash, sig));
    }

    public static ECKey signatureToKey(byte[] messageHash, String signatureBase64) throws SignatureException {
        byte[] keyBytes = ECKey.signatureToKeyBytes(messageHash, signatureBase64);
        return ECKey.fromPublicOnly(keyBytes);
    }

    public static boolean isPubKeyCanonical(byte[] pubkey) {
        if (pubkey[0] == 4) {
            return pubkey.length == 65;
        }
        if (pubkey[0] == 2 || pubkey[0] == 3) {
            return pubkey.length == 33;
        }
        return false;
    }

    @Nullable
    public static byte[] recoverPubBytesFromSignature(int recId, ECDSASignature sig, byte[] messageHash) {
        ECKey.check(recId >= 0, "recId must be positive");
        ECKey.check(sig.r.signum() >= 0, "r must be positive");
        ECKey.check(sig.s.signum() >= 0, "s must be positive");
        ECKey.check(messageHash != null, "messageHash must not be null");
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sig.r.add(i.multiply(n));
        ECCurve.Fp curve = (ECCurve.Fp)CURVE.getCurve();
        BigInteger prime = curve.getQ();
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        org.bouncycastle.math.ec.ECPoint R = ECKey.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, messageHash);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sig.r.modInverse(n);
        BigInteger srInv = rInv.multiply(sig.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint.Fp q = (ECPoint.Fp)ECAlgorithms.sumOfTwoMultiplies((org.bouncycastle.math.ec.ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (org.bouncycastle.math.ec.ECPoint)R, (BigInteger)srInv);
        return q.getEncoded(false);
    }

    @Nullable
    public static byte[] recoverAddressFromSignature(int recId, ECDSASignature sig, byte[] messageHash) {
        byte[] pubBytes = ECKey.recoverPubBytesFromSignature(recId, sig, messageHash);
        if (pubBytes == null) {
            return null;
        }
        return Hash.computeAddress(pubBytes);
    }

    @Nullable
    public static ECKey recoverFromSignature(int recId, ECDSASignature sig, byte[] messageHash) {
        byte[] pubBytes = ECKey.recoverPubBytesFromSignature(recId, sig, messageHash);
        if (pubBytes == null) {
            return null;
        }
        return ECKey.fromPublicOnly(pubBytes);
    }

    private static org.bouncycastle.math.ec.ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    private static void check(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public boolean isPubKeyOnly() {
        return this.privKey == null;
    }

    public boolean hasPrivKey() {
        return this.privKey != null;
    }

    @Override
    public byte[] getAddress() {
        if (this.pubKeyHash == null) {
            this.pubKeyHash = Hash.computeAddress(this.pub);
        }
        return this.pubKeyHash;
    }

    @Override
    public String signHash(byte[] hash) {
        return this.sign(hash).toBase64();
    }

    @Override
    public byte[] Base64toBytes(String signature) {
        byte[] signData = Base64.decode((String)signature);
        byte first = (byte)(signData[0] - 27);
        byte[] temp = Arrays.copyOfRange(signData, 1, 65);
        return ByteUtil.appendByte((byte[])temp, (byte)first);
    }

    @Override
    public byte[] getNodeId() {
        if (this.nodeId == null) {
            this.nodeId = ECKey.pubBytesWithoutFormat(this.pub);
        }
        return this.nodeId;
    }

    @Override
    public byte[] getPrivateKey() {
        return this.getPrivKeyBytes();
    }

    @Override
    public byte[] getPubKey() {
        return this.pub.getEncoded(false);
    }

    public org.bouncycastle.math.ec.ECPoint getPubKeyPoint() {
        return this.pub;
    }

    public BigInteger getPrivKey() {
        if (this.privKey == null) {
            throw new MissingPrivateKeyException();
        }
        if (this.privKey instanceof BCECPrivateKey) {
            return ((BCECPrivateKey)this.privKey).getD();
        }
        throw new MissingPrivateKeyException();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("pub:").append(Hex.toHexString((byte[])this.pub.getEncoded(false)));
        return b.toString();
    }

    public String toStringWithPrivate() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        if (this.privKey != null && this.privKey instanceof BCECPrivateKey) {
            b.append(" priv:").append(Hex.toHexString((byte[])((BCECPrivateKey)this.privKey).getD().toByteArray()));
        }
        return b.toString();
    }

    public ECDSASignature doSign(byte[] input) {
        if (input.length != 32) {
            throw new IllegalArgumentException("Expected 32 byte input to ECDSA signature, not " + input.length);
        }
        if (this.privKey == null) {
            throw new MissingPrivateKeyException();
        }
        if (this.privKey instanceof BCECPrivateKey) {
            ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
            ECPrivateKeyParameters privKeyParams = new ECPrivateKeyParameters(((BCECPrivateKey)this.privKey).getD(), CURVE);
            signer.init(true, (CipherParameters)privKeyParams);
            BigInteger[] components = signer.generateSignature(input);
            return new ECDSASignature(components[0], components[1]).toCanonicalised();
        }
        throw new RuntimeException("ECKey signing error");
    }

    public ECDSASignature sign(byte[] messageHash) {
        ECDSASignature sig = this.doSign(messageHash);
        int recId = -1;
        byte[] thisKey = this.pub.getEncoded(false);
        for (int i = 0; i < 4; ++i) {
            byte[] k = ECKey.recoverPubBytesFromSignature(i, sig, messageHash);
            if (k == null || !Arrays.equals(k, thisKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        sig.v = (byte)(recId + 27);
        return sig;
    }

    public boolean isPubKeyCanonical() {
        return ECKey.isPubKeyCanonical(this.pub.getEncoded(false));
    }

    @Nullable
    public byte[] getPrivKeyBytes() {
        if (this.privKey == null) {
            return null;
        }
        if (this.privKey instanceof BCECPrivateKey) {
            return ByteUtil.bigIntegerToBytes((BigInteger)((BCECPrivateKey)this.privKey).getD(), (int)32);
        }
        if (this.privKey instanceof ECPrivateKey) {
            return ByteUtil.bigIntegerToBytes((BigInteger)((ECPrivateKey)this.privKey).getS(), (int)32);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKey ecKey = (ECKey)o;
        if (this.privKey != null && !this.privKey.equals(ecKey.privKey)) {
            return false;
        }
        return this.pub == null || this.pub.equals(ecKey.pub);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getPubKey());
    }

    static {
        SECP256K1N = new BigInteger("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141", 16);
        X9ECParameters params = SECNamedCurves.getByName((String)"secp256k1");
        CURVE = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        CURVE_SPEC = new ECParameterSpec(params.getCurve(), params.getG(), params.getN(), params.getH());
        HALF_CURVE_ORDER = params.getN().shiftRight(1);
        secureRandom = new SecureRandom();
    }

    public static class MissingPrivateKeyException
    extends RuntimeException {
    }

    public static class ECDSASignature
    implements SignatureInterface {
        public final BigInteger r;
        public final BigInteger s;
        public byte v;

        public ECDSASignature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public ECDSASignature(byte[] r, byte[] s, byte v) {
            this.r = new BigInteger(1, r);
            this.s = new BigInteger(1, s);
            this.v = v;
        }

        private static ECDSASignature fromComponents(byte[] r, byte[] s) {
            return new ECDSASignature(new BigInteger(1, r), new BigInteger(1, s));
        }

        public static ECDSASignature fromComponents(byte[] r, byte[] s, byte v) {
            ECDSASignature signature = ECDSASignature.fromComponents(r, s);
            signature.v = v;
            return signature;
        }

        public static boolean validateComponents(BigInteger r, BigInteger s, byte v) {
            if (v != 27 && v != 28) {
                return false;
            }
            if (BIUtil.isLessThan((BigInteger)r, (BigInteger)BigInteger.ONE)) {
                return false;
            }
            if (BIUtil.isLessThan((BigInteger)s, (BigInteger)BigInteger.ONE)) {
                return false;
            }
            if (!BIUtil.isLessThan((BigInteger)r, (BigInteger)SECP256K1N)) {
                return false;
            }
            return BIUtil.isLessThan((BigInteger)s, (BigInteger)SECP256K1N);
        }

        @Override
        public boolean validateComponents() {
            return ECDSASignature.validateComponents(this.r, this.s, this.v);
        }

        public ECDSASignature toCanonicalised() {
            if (this.s.compareTo(HALF_CURVE_ORDER) > 0) {
                return new ECDSASignature(this.r, CURVE.getN().subtract(this.s));
            }
            return this;
        }

        public String toBase64() {
            byte[] sigData = new byte[65];
            sigData[0] = this.v;
            System.arraycopy(ByteUtil.bigIntegerToBytes((BigInteger)this.r, (int)32), 0, sigData, 1, 32);
            System.arraycopy(ByteUtil.bigIntegerToBytes((BigInteger)this.s, (int)32), 0, sigData, 33, 32);
            return new String(Base64.encode((byte[])sigData), Charset.forName("UTF-8"));
        }

        public byte[] toByteArray() {
            byte fixedV = this.v >= 27 ? (byte)(this.v - 27) : this.v;
            return ByteUtil.merge((byte[][])new byte[][]{ByteUtil.bigIntegerToBytes((BigInteger)this.r, (int)32), ByteUtil.bigIntegerToBytes((BigInteger)this.s, (int)32), {fixedV}});
        }

        public String toHex() {
            return Hex.toHexString((byte[])this.toByteArray());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ECDSASignature signature = (ECDSASignature)o;
            if (!this.r.equals(signature.r)) {
                return false;
            }
            return this.s.equals(signature.s);
        }

        public int hashCode() {
            int result = this.r.hashCode();
            result = 31 * result + this.s.hashCode();
            return result;
        }
    }
}

