/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import org.tron.common.utils.SlotBaseCounter;

public class SlidingWindowCounter {
    private volatile SlotBaseCounter slotBaseCounter;
    private volatile int windowSize;
    private volatile int head;

    public SlidingWindowCounter(int windowSize) {
        this.resizeWindow(windowSize);
    }

    public synchronized void resizeWindow(int windowSize) {
        this.windowSize = windowSize;
        this.slotBaseCounter = new SlotBaseCounter(windowSize);
        this.head = 0;
    }

    public void increase() {
        this.slotBaseCounter.increaseSlot(this.head);
    }

    public int totalAndAdvance() {
        int total = this.totalCount();
        this.advance();
        return total;
    }

    public void advance() {
        int tail = (this.head + 1) % this.windowSize;
        this.slotBaseCounter.wipeSlot(tail);
        this.head = tail;
    }

    public int totalCount() {
        return this.slotBaseCounter.totalCount();
    }

    public String toString() {
        return "total = " + this.totalCount() + " head = " + this.head + " >> " + this.slotBaseCounter;
    }
}

