/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import com.sun.management.OperatingSystemMXBean;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class OperatingSystemExports
extends Collector {
    private static final String SYSTEM_AVAILABLE_CPUS = "system_available_cpus";
    private static final String PROCESS_CPU_LOAD = "process_cpu_load";
    private static final String SYSTEM_CPU_LOAD = "system_cpu_load";
    private static final String SYSTEM_LOAD_AVERAGE = "system_load_average";
    private static final String SYSTEM_TOTAL_PHYSICAL_MEMORY_BYTES = "system_total_physical_memory_bytes";
    private static final String SYSTEM_FREE_PHYSICAL_MEMORY_BYTES = "system_free_physical_memory_bytes";
    private static final String SYSTEM_TOTAL_SWAP_SPACES_BYTES = "system_total_swap_spaces_bytes";
    private static final String SYSTEM_FREE_SWAP_SPACES_BYTES = "system_free_swap_spaces_bytes";
    private final OperatingSystemMXBean operatingSystemMXBean;

    public OperatingSystemExports() {
        this((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean());
    }

    public OperatingSystemExports(OperatingSystemMXBean operatingSystemMXBean) {
        this.operatingSystemMXBean = operatingSystemMXBean;
    }

    void addOperatingSystemMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test((Object)SYSTEM_AVAILABLE_CPUS)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_AVAILABLE_CPUS, "System available cpus", (double)this.operatingSystemMXBean.getAvailableProcessors()));
        }
        if (nameFilter.test((Object)PROCESS_CPU_LOAD)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(PROCESS_CPU_LOAD, "Process cpu load", this.operatingSystemMXBean.getProcessCpuLoad()));
        }
        if (nameFilter.test((Object)SYSTEM_CPU_LOAD)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_CPU_LOAD, "System cpu load", this.operatingSystemMXBean.getSystemCpuLoad()));
        }
        if (nameFilter.test((Object)SYSTEM_LOAD_AVERAGE)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_LOAD_AVERAGE, "System cpu load average", this.operatingSystemMXBean.getSystemLoadAverage()));
        }
        if (nameFilter.test((Object)SYSTEM_TOTAL_PHYSICAL_MEMORY_BYTES)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_TOTAL_PHYSICAL_MEMORY_BYTES, "System total physical memory bytes", (double)this.operatingSystemMXBean.getTotalPhysicalMemorySize()));
        }
        if (nameFilter.test((Object)SYSTEM_FREE_PHYSICAL_MEMORY_BYTES)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_FREE_PHYSICAL_MEMORY_BYTES, "System free physical memory bytes", (double)this.operatingSystemMXBean.getFreePhysicalMemorySize()));
        }
        if (nameFilter.test((Object)SYSTEM_TOTAL_SWAP_SPACES_BYTES)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_TOTAL_SWAP_SPACES_BYTES, "System free swap spaces bytes", (double)this.operatingSystemMXBean.getTotalSwapSpaceSize()));
        }
        if (nameFilter.test((Object)SYSTEM_FREE_SWAP_SPACES_BYTES)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(SYSTEM_FREE_SWAP_SPACES_BYTES, "System free swap spaces", (double)this.operatingSystemMXBean.getFreeSwapSpaceSize()));
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addOperatingSystemMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        return mfs;
    }
}

