/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.cedarsoftware.util.DeepEquals;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.CompactEncoder;

public class Value {
    private Object value;
    private byte[] serializable;
    private byte[] sha3;
    private boolean decoded = false;

    public Value() {
    }

    public Value(Object obj) {
        this.decoded = true;
        if (obj == null) {
            return;
        }
        this.value = obj instanceof Value ? ((Value)obj).asObj() : obj;
    }

    public void init(byte[] serializable) {
        this.serializable = serializable;
    }

    public Object asObj() {
        return this.value;
    }

    public List<Object> asList() {
        Object[] valueArray = (Object[])this.value;
        return Arrays.asList(valueArray);
    }

    public int asInt() {
        if (this.isInt()) {
            return (Integer)this.value;
        }
        if (this.isBytes()) {
            return new BigInteger(1, this.asBytes()).intValue();
        }
        return 0;
    }

    public long asLong() {
        if (this.isLong()) {
            return (Long)this.value;
        }
        if (this.isBytes()) {
            return new BigInteger(1, this.asBytes()).longValueExact();
        }
        return 0L;
    }

    public BigInteger asBigInt() {
        return (BigInteger)this.value;
    }

    public String asString() {
        if (this.isBytes()) {
            return new String((byte[])this.value);
        }
        if (this.isString()) {
            return (String)this.value;
        }
        return "";
    }

    public byte[] asBytes() {
        if (this.isBytes()) {
            return (byte[])this.value;
        }
        if (this.isString()) {
            return this.asString().getBytes();
        }
        return ByteUtil.EMPTY_BYTE_ARRAY;
    }

    public Value get(int index) {
        if (this.isList()) {
            if (this.asList().size() <= index) {
                return new Value(null);
            }
            if (index < 0) {
                throw new RuntimeException("Negative index not allowed");
            }
            return new Value(this.asList().get(index));
        }
        return new Value(null);
    }

    public boolean cmp(Value o) {
        return DeepEquals.deepEquals((Object)this, (Object)o);
    }

    public boolean isList() {
        return this.value != null && this.value.getClass().isArray() && !this.value.getClass().getComponentType().isPrimitive();
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isInt() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isBigInt() {
        return this.value instanceof BigInteger;
    }

    public boolean isBytes() {
        return this.value instanceof byte[];
    }

    public boolean isReadableString() {
        int readableChars = 0;
        byte[] data = (byte[])this.value;
        if (data.length == 1 && data[0] > 31 && data[0] < 126) {
            return true;
        }
        for (byte aData : data) {
            if (aData <= 32 || aData >= 126) continue;
            ++readableChars;
        }
        return (double)readableChars / (double)data.length > 0.55;
    }

    public boolean isHexString() {
        byte[] data;
        int hexChars = 0;
        for (byte aData : data = (byte[])this.value) {
            if ((aData < 48 || aData > 57) && (aData < 97 || aData > 102)) continue;
            ++hexChars;
        }
        return (double)hexChars / (double)data.length > 0.9;
    }

    public boolean isHashCode() {
        return this.asBytes().length == 32;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isEmpty() {
        if (this.isNull()) {
            return true;
        }
        if (this.isBytes() && this.asBytes().length == 0) {
            return true;
        }
        if (this.isList() && this.asList().isEmpty()) {
            return true;
        }
        return this.isString() && this.asString().equals("");
    }

    public int length() {
        if (this.isList()) {
            return this.asList().size();
        }
        if (this.isBytes()) {
            return this.asBytes().length;
        }
        if (this.isString()) {
            return this.asString().length();
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isList()) {
            Object[] list = (Object[])this.value;
            if (list.length == 2) {
                stringBuilder.append("[ ");
                Value key = new Value(list[0]);
                byte[] keyNibbles = CompactEncoder.binToNibblesNoTerminator(key.asBytes());
                String keyString = ByteUtil.nibblesToPrettyString(keyNibbles);
                stringBuilder.append(keyString);
                stringBuilder.append(",");
                Value val = new Value(list[1]);
                stringBuilder.append(val.toString());
                stringBuilder.append(" ]");
                return stringBuilder.toString();
            }
            stringBuilder.append(" [");
            for (int i = 0; i < list.length; ++i) {
                Value val = new Value(list[i]);
                if (val.isString() || val.isEmpty()) {
                    stringBuilder.append("'").append(val.toString()).append("'");
                } else {
                    stringBuilder.append(val.toString());
                }
                if (i >= list.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("] ");
            return stringBuilder.toString();
        }
        if (this.isEmpty()) {
            return "";
        }
        if (this.isBytes()) {
            StringBuilder output = new StringBuilder();
            if (this.isHashCode()) {
                output.append(Hex.toHexString((byte[])this.asBytes()));
            } else if (this.isReadableString()) {
                output.append("'");
                for (byte oneByte : this.asBytes()) {
                    if (oneByte < 16) {
                        output.append("\\x").append(ByteUtil.oneByteToHexString(oneByte));
                        continue;
                    }
                    output.append(Character.valueOf((char)oneByte));
                }
                output.append("'");
                return output.toString();
            }
            return Hex.toHexString((byte[])this.asBytes());
        }
        if (this.isString()) {
            return this.asString();
        }
        return "Unexpected type";
    }

    public int countBranchNodes() {
        if (this.isList()) {
            return this.asList().stream().mapToInt(obj -> new Value(obj).countBranchNodes()).sum();
        }
        if (this.isBytes()) {
            this.asBytes();
        }
        return 0;
    }
}

