/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

public abstract class FastByteComparisons {
    public static boolean isEqual(byte[] b1, byte[] b2) {
        return b1.length == b2.length && FastByteComparisons.compareTo(b1, 0, b1.length, b2, 0, b2.length) == 0;
    }

    public static int compareTo(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, s1, l1, b2, s2, l2);
    }

    private static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    private static class LexicographicalComparerHolder {
        private static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        private static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        private LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return FastByteComparisons.lexicographicalComparerJavaImpl();
            }
        }

        private static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    private static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }
}

