/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.db.TransactionStore;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;
import org.tron.protos.Protocol;

@Component
public class TransactionRetStore
extends TronStoreWithRevoking<TransactionRetCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    @Autowired
    private TransactionStore transactionStore;

    @Autowired
    public TransactionRetStore(@Value(value="transactionRetStore") String dbName) {
        super(dbName);
    }

    @Override
    public void put(byte[] key, TransactionRetCapsule item) {
        if (BooleanUtils.toBoolean((String)CommonParameter.getInstance().getStorage().getTransactionHistorySwitch())) {
            super.put(key, item);
        }
    }

    public TransactionInfoCapsule getTransactionInfo(byte[] key) throws BadItemException {
        long blockNumber = this.transactionStore.getBlockNumber(key);
        if (blockNumber == -1L) {
            return null;
        }
        byte[] value = this.revokingDB.getUnchecked(ByteArray.fromLong((long)blockNumber));
        if (Objects.isNull(value)) {
            return null;
        }
        TransactionRetCapsule result = new TransactionRetCapsule(value);
        if (Objects.isNull(result.getInstance())) {
            return null;
        }
        ByteString id = ByteString.copyFrom((byte[])key);
        for (Protocol.TransactionInfo transactionResultInfo : result.getInstance().getTransactioninfoList()) {
            if (!transactionResultInfo.getId().equals((Object)id)) continue;
            Protocol.ResourceReceipt receipt = transactionResultInfo.getReceipt();
            if (receipt.getEnergyUsageTotal() == 0L && receipt.getOriginEnergyUsage() > 0L) {
                transactionResultInfo = transactionResultInfo.toBuilder().setReceipt(receipt.toBuilder().clearOriginEnergyUsage().build()).build();
            }
            return new TransactionInfoCapsule(transactionResultInfo);
        }
        return null;
    }

    public TransactionRetCapsule getTransactionInfoByBlockNum(byte[] key) throws BadItemException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (Objects.isNull(value)) {
            return null;
        }
        return new TransactionRetCapsule(value);
    }
}

