/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class DelegationStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    public static final long REMARK = -1L;
    public static final int DEFAULT_BROKERAGE = 20;
    public static final BigInteger DECIMAL_OF_VI_REWARD = BigInteger.valueOf(10L).pow(18);

    @Autowired
    public DelegationStore(@Value(value="delegation") String dbName) {
        super(dbName);
    }

    @Override
    public BytesCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new BytesCapsule(value);
    }

    public void addReward(long cycle, byte[] address, long value) {
        byte[] key = this.buildRewardKey(cycle, address);
        BytesCapsule bytesCapsule = this.get(key);
        if (bytesCapsule == null) {
            this.put(key, new BytesCapsule(ByteArray.fromLong((long)value)));
        } else {
            this.put(key, new BytesCapsule(ByteArray.fromLong((long)(ByteArray.toLong((byte[])bytesCapsule.getData()) + value))));
        }
    }

    public long getReward(long cycle, byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildRewardKey(cycle, address));
        if (bytesCapsule == null) {
            return 0L;
        }
        return ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    public void setBeginCycle(byte[] address, long number) {
        this.put(address, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getBeginCycle(byte[] address) {
        BytesCapsule bytesCapsule = this.get(address);
        return bytesCapsule == null ? 0L : ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    public void setEndCycle(byte[] address, long number) {
        this.put(this.buildEndCycleKey(address), new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getEndCycle(byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildEndCycleKey(address));
        return bytesCapsule == null ? -1L : ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    public void setWitnessVote(long cycle, byte[] address, long value) {
        this.put(this.buildVoteKey(cycle, address), new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getWitnessVote(long cycle, byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildVoteKey(cycle, address));
        if (bytesCapsule == null) {
            return -1L;
        }
        return ByteArray.toLong((byte[])bytesCapsule.getData());
    }

    public void setAccountVote(long cycle, byte[] address, AccountCapsule accountCapsule) {
        this.put(this.buildAccountVoteKey(cycle, address), new BytesCapsule(accountCapsule.getData()));
    }

    public AccountCapsule getAccountVote(long cycle, byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildAccountVoteKey(cycle, address));
        if (bytesCapsule == null) {
            return null;
        }
        return new AccountCapsule(bytesCapsule.getData());
    }

    public void setBrokerage(long cycle, byte[] address, int brokerage) {
        this.put(this.buildBrokerageKey(cycle, address), new BytesCapsule(ByteArray.fromInt((int)brokerage)));
    }

    public int getBrokerage(long cycle, byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildBrokerageKey(cycle, address));
        if (bytesCapsule == null) {
            return 20;
        }
        return ByteArray.toInt((byte[])bytesCapsule.getData());
    }

    public void setBrokerage(byte[] address, int brokerage) {
        this.setBrokerage(-1L, address, brokerage);
    }

    public int getBrokerage(byte[] address) {
        return this.getBrokerage(-1L, address);
    }

    public void setWitnessVi(long cycle, byte[] address, BigInteger value) {
        this.put(this.buildViKey(cycle, address), new BytesCapsule(value.toByteArray()));
    }

    public BigInteger getWitnessVi(long cycle, byte[] address) {
        BytesCapsule bytesCapsule = this.get(this.buildViKey(cycle, address));
        if (bytesCapsule == null) {
            return BigInteger.ZERO;
        }
        return new BigInteger(bytesCapsule.getData());
    }

    public void accumulateWitnessVi(long cycle, byte[] address, long voteCount) {
        BigInteger preVi = this.getWitnessVi(cycle - 1L, address);
        long reward = this.getReward(cycle, address);
        if (reward == 0L || voteCount == 0L) {
            if (!BigInteger.ZERO.equals(preVi)) {
                this.setWitnessVi(cycle, address, preVi);
            }
        } else {
            BigInteger deltaVi = BigInteger.valueOf(reward).multiply(DECIMAL_OF_VI_REWARD).divide(BigInteger.valueOf(voteCount));
            this.setWitnessVi(cycle, address, preVi.add(deltaVi));
        }
    }

    private byte[] buildVoteKey(long cycle, byte[] address) {
        return (cycle + "-" + Hex.toHexString((byte[])address) + "-vote").getBytes();
    }

    private byte[] buildRewardKey(long cycle, byte[] address) {
        return (cycle + "-" + Hex.toHexString((byte[])address) + "-reward").getBytes();
    }

    private byte[] buildAccountVoteKey(long cycle, byte[] address) {
        return (cycle + "-" + Hex.toHexString((byte[])address) + "-account-vote").getBytes();
    }

    private byte[] buildEndCycleKey(byte[] address) {
        return ("end-" + Hex.toHexString((byte[])address)).getBytes();
    }

    private byte[] buildBrokerageKey(long cycle, byte[] address) {
        return (cycle + "-" + Hex.toHexString((byte[])address) + "-brokerage").getBytes();
    }

    private byte[] buildViKey(long cycle, byte[] address) {
        return (cycle + "-" + Hex.toHexString((byte[])address) + "-vi").getBytes();
    }
}

