/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.db.TronDatabase;
import org.tron.core.db2.common.WrappedByteArray;
import org.tron.protos.Protocol;

@Component
public class AccountAssetStore
extends TronDatabase<byte[]> {
    @Autowired
    protected AccountAssetStore(@Value(value="account-asset") String dbName) {
        super(dbName);
    }

    @Override
    public void put(byte[] key, byte[] item) {
        this.dbSource.putData(key, item);
    }

    @Override
    public void delete(byte[] key) {
        this.dbSource.deleteData(key);
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.dbSource.getData(key);
    }

    @Override
    public boolean has(byte[] key) {
        return this.dbSource.getData(key) != null;
    }

    public void putAccount(Protocol.Account account) {
        Map<byte[], byte[]> assets = AccountAssetStore.convert(this.getAssets(account));
        if (!assets.isEmpty()) {
            this.updateByBatch(assets);
        }
    }

    public void deleteAccount(byte[] key) {
        Map<byte[], byte[]> assets = AccountAssetStore.convert(this.getDeletedAssets(key));
        if (!assets.isEmpty()) {
            this.updateByBatch(assets);
        }
    }

    public Map<WrappedByteArray, WrappedByteArray> getAssets(Protocol.Account account) {
        HashMap<WrappedByteArray, WrappedByteArray> assets = new HashMap<WrappedByteArray, WrappedByteArray>();
        account.getAssetV2Map().forEach((? super K k, ? super V v) -> {
            byte[] key = Bytes.concat((byte[][])new byte[][]{account.getAddress().toByteArray(), k.getBytes()});
            if (v == 0L) {
                assets.put(WrappedByteArray.of(key), WrappedByteArray.of(null));
            } else {
                assets.put(WrappedByteArray.of(key), WrappedByteArray.of(Longs.toByteArray((long)v)));
            }
        });
        return assets;
    }

    public Map<WrappedByteArray, WrappedByteArray> getDeletedAssets(byte[] key) {
        HashMap<WrappedByteArray, WrappedByteArray> assets = new HashMap<WrappedByteArray, WrappedByteArray>();
        this.prefixQuery(key).forEach((? super K k, ? super V v) -> assets.put(WrappedByteArray.of(k.getBytes()), WrappedByteArray.of(null)));
        return assets;
    }

    public static Map<byte[], byte[]> convert(Map<WrappedByteArray, WrappedByteArray> map) {
        HashMap<byte[], byte[]> assets = new HashMap<byte[], byte[]>();
        map.forEach((? super K k, ? super V v) -> assets.put(k.getBytes(), v.getBytes()));
        return assets;
    }

    public long getBalance(Protocol.Account account, byte[] key) {
        if (!account.getAssetOptimized()) {
            return 0L;
        }
        byte[] k = Bytes.concat((byte[][])new byte[][]{account.getAddress().toByteArray(), key});
        byte[] value = this.get(k);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return 0L;
        }
        return Longs.fromByteArray((byte[])value);
    }

    public Map<String, Long> getAllAssets(Protocol.Account account) {
        HashMap<String, Long> assets = new HashMap<String, Long>();
        if (account.getAssetOptimized()) {
            Map<WrappedByteArray, byte[]> map = this.prefixQuery(account.getAddress().toByteArray());
            map.forEach((? super K k, ? super V v) -> {
                byte[] assetID = ByteArray.subArray((byte[])k.getBytes(), (int)account.getAddress().toByteArray().length, (int)k.getBytes().length);
                assets.put(ByteArray.toStr((byte[])assetID), Longs.fromByteArray((byte[])v));
            });
        }
        account.getAssetV2Map().forEach((? super K k, ? super V v) -> assets.put((String)k, (Long)v));
        return assets;
    }
}

