/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.AbiCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class AbiStore
extends TronStoreWithRevoking<AbiCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    private AbiStore(@Value(value="abi") String dbName) {
        super(dbName);
    }

    @Override
    public AbiCapsule get(byte[] key) {
        return (AbiCapsule)this.getUnchecked(key);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        if (Objects.isNull(key) || Objects.isNull(value)) {
            return;
        }
        this.revokingDB.put(key, value);
    }

    public long getTotalABIs() {
        return Streams.stream(this.revokingDB.iterator()).count();
    }
}

