/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.common;

import java.util.Arrays;
import org.tron.core.db2.common.WrappedByteArray;

public final class Value {
    private final Operator operator;
    private final WrappedByteArray data;

    private Value(Operator operator, WrappedByteArray data) {
        this.operator = operator;
        this.data = data;
    }

    public static Value decode(byte[] bytes) {
        Operator operator = Operator.valueOf(bytes[0]);
        byte[] value = null;
        if (bytes.length > 1) {
            value = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return Value.of(operator, value);
    }

    public static Value copyOf(Operator operator, byte[] data) {
        return new Value(operator, WrappedByteArray.copyOf(data));
    }

    public static Value of(Operator operator, byte[] data) {
        return new Value(operator, WrappedByteArray.of(data));
    }

    public byte[] encode() {
        if (this.data.getBytes() == null) {
            return new byte[]{this.operator.getValue()};
        }
        byte[] r = new byte[1 + this.data.getBytes().length];
        r[0] = this.operator.getValue();
        System.arraycopy(this.data.getBytes(), 0, r, 1, this.data.getBytes().length);
        return r;
    }

    public byte[] getBytes() {
        byte[] value = this.data.getBytes();
        if (value == null) {
            return null;
        }
        return Arrays.copyOf(value, value.length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        WrappedByteArray this$data = this.data;
        WrappedByteArray other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WrappedByteArray $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static enum Operator {
        CREATE(0),
        MODIFY(1),
        DELETE(2),
        PUT(3);

        private byte value;

        private Operator(byte value) {
            this.value = value;
        }

        static Operator valueOf(byte b) {
            switch (b) {
                case 0: {
                    return CREATE;
                }
                case 1: {
                    return MODIFY;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return PUT;
                }
            }
            return null;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

