/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.db.TronDatabase;

@Component
public class CommonDataBase
extends TronDatabase<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final byte[] LATEST_PBFT_BLOCK_NUM = "LATEST_PBFT_BLOCK_NUM".getBytes();

    public CommonDataBase() {
        super("common-database");
    }

    @Override
    public void put(byte[] key, byte[] item) {
        this.dbSource.putData(key, item);
    }

    @Override
    public void delete(byte[] key) {
        this.dbSource.deleteData(key);
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.dbSource.getData(key);
    }

    @Override
    public boolean has(byte[] key) {
        return this.dbSource.getData(key) != null;
    }

    public void saveLatestPbftBlockNum(long number) {
        if (number <= this.getLatestPbftBlockNum()) {
            logger.warn("PBFT number {} <= latest number {}.", (Object)number, (Object)this.getLatestPbftBlockNum());
            return;
        }
        this.put(LATEST_PBFT_BLOCK_NUM, ByteArray.fromLong((long)number));
    }

    public long getLatestPbftBlockNum() {
        return Optional.ofNullable(this.get(LATEST_PBFT_BLOCK_NUM)).map(ByteArray::toLong).orElse(0L);
    }
}

