/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.primitives.Bytes;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignUtils;
import org.tron.common.es.ExecutorServiceManager;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ForkController;
import org.tron.common.utils.ReflectUtils;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.WalletUtil;
import org.tron.core.actuator.TransactionFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.db.TransactionContext;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.P2pException;
import org.tron.core.exception.PermissionException;
import org.tron.core.exception.SignatureFormatException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;
import org.tron.protos.contract.WitnessContract;

public class TransactionCapsule
implements ProtoCapsule<Protocol.Transaction> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private static final String esName = "valid-contract-proto";
    private static final ExecutorService executorService = ExecutorServiceManager.newFixedThreadPool((String)"valid-contract-proto", (int)CommonParameter.getInstance().getValidContractProtoThreadNum());
    private static final String OWNER_ADDRESS = "ownerAddress_";
    private Protocol.Transaction transaction;
    private boolean isVerified = false;
    private long blockNum = -1L;
    private TransactionTrace trxTrace;
    private long time;
    private long order;
    private byte[] ownerAddress;
    private Sha256Hash id;
    private boolean isTransactionCreate = false;
    private boolean isInBlock = false;

    public byte[] getOwnerAddress() {
        if (this.ownerAddress == null) {
            this.ownerAddress = TransactionCapsule.getOwner(this.transaction.getRawData().getContract(0));
        }
        return this.ownerAddress;
    }

    public TransactionCapsule(Protocol.Transaction trx) {
        this.transaction = trx;
    }

    public TransactionCapsule(byte[] data) throws BadItemException {
        try {
            this.transaction = Protocol.Transaction.parseFrom((CodedInputStream)org.tron.common.overlay.message.Message.getCodedInputStream(data));
        }
        catch (Exception e) {
            throw new BadItemException("Transaction proto data parse exception");
        }
    }

    public TransactionCapsule(CodedInputStream codedInputStream) throws BadItemException {
        try {
            this.transaction = Protocol.Transaction.parseFrom((CodedInputStream)codedInputStream);
        }
        catch (IOException e) {
            throw new BadItemException("Transaction proto data parse exception");
        }
    }

    public TransactionCapsule(AccountContract.AccountCreateContract contract, AccountStore accountStore) {
        AccountCapsule account = accountStore.get(contract.getOwnerAddress().toByteArray());
        if (account != null && account.getType() == contract.getType()) {
            return;
        }
        this.createTransaction((Message)contract, Protocol.Transaction.Contract.ContractType.AccountCreateContract);
    }

    public TransactionCapsule(BalanceContract.TransferContract contract, AccountStore accountStore) {
        AccountCapsule owner = accountStore.get(contract.getOwnerAddress().toByteArray());
        if (owner == null || owner.getBalance() < contract.getAmount()) {
            return;
        }
        this.createTransaction((Message)contract, Protocol.Transaction.Contract.ContractType.TransferContract);
    }

    public TransactionCapsule(WitnessContract.VoteWitnessContract voteWitnessContract) {
        this.createTransaction((Message)voteWitnessContract, Protocol.Transaction.Contract.ContractType.VoteWitnessContract);
    }

    public TransactionCapsule(WitnessContract.WitnessCreateContract witnessCreateContract) {
        this.createTransaction((Message)witnessCreateContract, Protocol.Transaction.Contract.ContractType.WitnessCreateContract);
    }

    public TransactionCapsule(WitnessContract.WitnessUpdateContract witnessUpdateContract) {
        this.createTransaction((Message)witnessUpdateContract, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract);
    }

    public TransactionCapsule(AssetIssueContractOuterClass.TransferAssetContract transferAssetContract) {
        this.createTransaction((Message)transferAssetContract, Protocol.Transaction.Contract.ContractType.TransferAssetContract);
    }

    public TransactionCapsule(AssetIssueContractOuterClass.ParticipateAssetIssueContract participateAssetIssueContract) {
        this.createTransaction((Message)participateAssetIssueContract, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract);
    }

    public TransactionCapsule(Protocol.Transaction.raw rawData, List<ByteString> signatureList) {
        this.transaction = Protocol.Transaction.newBuilder().setRawData(rawData).addAllSignature(signatureList).build();
    }

    @Deprecated
    public TransactionCapsule(AssetIssueContractOuterClass.AssetIssueContract assetIssueContract) {
        this.createTransaction((Message)assetIssueContract, Protocol.Transaction.Contract.ContractType.AssetIssueContract);
    }

    public TransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) {
        Protocol.Transaction.raw.Builder transactionBuilder = Protocol.Transaction.raw.newBuilder().addContract(Protocol.Transaction.Contract.newBuilder().setType(contractType).setParameter(message instanceof Any ? (Any)message : Any.pack((Message)message)).build());
        this.transaction = Protocol.Transaction.newBuilder().setRawData(transactionBuilder.build()).build();
    }

    public static long getWeight(Protocol.Permission permission, byte[] address) {
        List list = permission.getKeysList();
        for (Protocol.Key key : list) {
            if (!key.getAddress().equals((Object)ByteString.copyFrom((byte[])address))) continue;
            return key.getWeight();
        }
        return 0L;
    }

    public static long checkWeight(Protocol.Permission permission, List<ByteString> sigs, byte[] hash, List<ByteString> approveList) throws SignatureException, PermissionException, SignatureFormatException {
        long currentWeight = 0L;
        if (sigs.size() > permission.getKeysCount()) {
            throw new PermissionException("Signature count is " + sigs.size() + " more than key counts of permission : " + permission.getKeysCount());
        }
        HashMap<String, Long> addMap = new HashMap<String, Long>();
        for (ByteString sig : sigs) {
            if (sig.size() < 65) {
                throw new SignatureFormatException("Signature size is " + sig.size());
            }
            String base64 = TransactionCapsule.getBase64FromByteString(sig);
            byte[] address = SignUtils.signatureToAddress((byte[])hash, (String)base64, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
            long weight = TransactionCapsule.getWeight(permission, address);
            if (weight == 0L) {
                throw new PermissionException(ByteArray.toHexString((byte[])sig.toByteArray()) + " is signed by " + StringUtil.encode58Check((byte[])address) + " but it is not contained of permission.");
            }
            if (ForkController.instance().pass(Parameter.ForkBlockVersionEnum.VERSION_4_7_1)) {
                base64 = StringUtil.encode58Check((byte[])address);
            }
            if (addMap.containsKey(base64)) {
                throw new PermissionException(StringUtil.encode58Check((byte[])address) + " has signed twice!");
            }
            addMap.put(base64, weight);
            if (approveList != null) {
                approveList.add(ByteString.copyFrom((byte[])address));
            }
            currentWeight += weight;
        }
        return currentWeight;
    }

    public static byte[] getShieldTransactionHashIgnoreTypeException(Protocol.Transaction tx) {
        try {
            return TransactionCapsule.hashShieldTransaction(tx, CommonParameter.getInstance().getZenTokenId());
        }
        catch (InvalidProtocolBufferException | ContractValidateException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
    }

    public static byte[] hashShieldTransaction(Protocol.Transaction tx, String tokenId) throws ContractValidateException, InvalidProtocolBufferException {
        Any contractParameter = tx.getRawData().getContract(0).getParameter();
        if (!contractParameter.is(ShieldContract.ShieldedTransferContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ShieldedTransferContract],real type[" + contractParameter.getClass() + "]");
        }
        ShieldContract.ShieldedTransferContract shieldedTransferContract = (ShieldContract.ShieldedTransferContract)contractParameter.unpack(ShieldContract.ShieldedTransferContract.class);
        ShieldContract.ShieldedTransferContract.Builder newContract = ShieldContract.ShieldedTransferContract.newBuilder();
        newContract.setFromAmount(shieldedTransferContract.getFromAmount());
        newContract.addAllReceiveDescription((Iterable)shieldedTransferContract.getReceiveDescriptionList());
        newContract.setToAmount(shieldedTransferContract.getToAmount());
        newContract.setTransparentFromAddress(shieldedTransferContract.getTransparentFromAddress());
        newContract.setTransparentToAddress(shieldedTransferContract.getTransparentToAddress());
        for (ShieldContract.SpendDescription spendDescription : shieldedTransferContract.getSpendDescriptionList()) {
            newContract.addSpendDescription(spendDescription.toBuilder().clearSpendAuthoritySignature().build());
        }
        Protocol.Transaction.raw.Builder rawBuilder = tx.toBuilder().getRawDataBuilder().clearContract().addContract(Protocol.Transaction.Contract.newBuilder().setType(Protocol.Transaction.Contract.ContractType.ShieldedTransferContract).setParameter(Any.pack((Message)newContract.build())).build());
        Protocol.Transaction transaction = tx.toBuilder().clearRawData().setRawData(rawBuilder).build();
        byte[] mergedByte = Bytes.concat((byte[][])new byte[][]{Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])tokenId.getBytes()).getBytes(), transaction.getRawData().toByteArray()});
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])mergedByte).getBytes();
    }

    public static byte[] getOwner(Protocol.Transaction.Contract contract) {
        try {
            ByteString owner;
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case ShieldedTransferContract: {
                    ShieldContract.ShieldedTransferContract shieldedTransferContract = (ShieldContract.ShieldedTransferContract)contractParameter.unpack(ShieldContract.ShieldedTransferContract.class);
                    if (!shieldedTransferContract.getTransparentFromAddress().isEmpty()) {
                        owner = shieldedTransferContract.getTransparentFromAddress();
                        break;
                    }
                    return new byte[0];
                }
                default: {
                    Class<? extends GeneratedMessageV3> clazz = TransactionFactory.getContract(contract.getType());
                    if (clazz == null) {
                        logger.warn("not exist {}", (Object)contract.getType());
                        return new byte[0];
                    }
                    GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)contractParameter.unpack(clazz);
                    owner = (ByteString)ReflectUtils.getFieldValue((Object)generatedMessageV3, (String)OWNER_ADDRESS);
                    if (owner != null) break;
                    logger.warn("not exist [{}] field,{}", (Object)OWNER_ADDRESS, clazz);
                    return new byte[0];
                }
            }
            return owner.toByteArray();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            logger.warn("InvalidProtocolBufferException occurred because {}, please verify the interface input parameters", (Object)invalidProtocolBufferException.getMessage());
            return new byte[0];
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return new byte[0];
        }
    }

    public static <T extends Message> T parse(Class<T> clazz, CodedInputStream codedInputStream) throws InvalidProtocolBufferException {
        Message defaultInstance = (Message)Internal.getDefaultInstance(clazz);
        return (T)((Message)defaultInstance.getParserForType().parseFrom(codedInputStream));
    }

    public static void validContractProto(List<Protocol.Transaction> transactionList) throws P2pException {
        ArrayList futureList = new ArrayList();
        transactionList.forEach(transaction -> {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    TransactionCapsule.validContractProto(transaction.getRawData().getContract(0));
                    return true;
                }
                catch (Exception e) {
                    logger.error("{}", (Object)e.getMessage());
                    return false;
                }
            });
            futureList.add(future);
        });
        for (Future future : futureList) {
            try {
                if (((Boolean)future.get()).booleanValue()) continue;
                throw new P2pException(P2pException.TypeEnum.PROTOBUF_ERROR, P2pException.TypeEnum.PROTOBUF_ERROR.getDesc());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new P2pException(P2pException.TypeEnum.PROTOBUF_ERROR, P2pException.TypeEnum.PROTOBUF_ERROR.getDesc());
            }
        }
    }

    public static void validContractProto(Protocol.Transaction.Contract contract) throws InvalidProtocolBufferException, P2pException {
        Any contractParameter = contract.getParameter();
        Class<? extends GeneratedMessageV3> clazz = TransactionFactory.getContract(contract.getType());
        if (clazz == null) {
            throw new P2pException(P2pException.TypeEnum.PROTOBUF_ERROR, P2pException.TypeEnum.PROTOBUF_ERROR.getDesc());
        }
        Message src = contractParameter.unpack(clazz);
        GeneratedMessageV3 contractMessage = TransactionCapsule.parse(clazz, org.tron.common.overlay.message.Message.getCodedInputStream(src.toByteArray()));
        org.tron.common.overlay.message.Message.compareBytes(src.toByteArray(), contractMessage.toByteArray());
    }

    public static byte[] getToAddress(Protocol.Transaction.Contract contract) {
        try {
            ByteString to;
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TransferContract: {
                    to = ((BalanceContract.TransferContract)contractParameter.unpack(BalanceContract.TransferContract.class)).getToAddress();
                    break;
                }
                case TransferAssetContract: {
                    to = ((AssetIssueContractOuterClass.TransferAssetContract)contractParameter.unpack(AssetIssueContractOuterClass.TransferAssetContract.class)).getToAddress();
                    break;
                }
                case ParticipateAssetIssueContract: {
                    to = ((AssetIssueContractOuterClass.ParticipateAssetIssueContract)contractParameter.unpack(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class)).getToAddress();
                    break;
                }
                default: {
                    return new byte[0];
                }
            }
            return to.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return new byte[0];
        }
    }

    public static long getCallValue(Protocol.Transaction.Contract contract) {
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TriggerSmartContract: {
                    return ((SmartContractOuterClass.TriggerSmartContract)contractParameter.unpack(SmartContractOuterClass.TriggerSmartContract.class)).getCallValue();
                }
                case CreateSmartContract: {
                    return ((SmartContractOuterClass.CreateSmartContract)contractParameter.unpack(SmartContractOuterClass.CreateSmartContract.class)).getNewContract().getCallValue();
                }
            }
            return 0L;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0L;
        }
    }

    public static String getBase64FromByteString(ByteString sign) {
        byte[] r = sign.substring(0, 32).toByteArray();
        byte[] s = sign.substring(32, 64).toByteArray();
        byte v = sign.byteAt(64);
        if (v < 27) {
            v = (byte)(v + 27);
        }
        ECKey.ECDSASignature signature = ECKey.ECDSASignature.fromComponents((byte[])r, (byte[])s, (byte)v);
        return signature.toBase64();
    }

    public static boolean validateSignature(Protocol.Transaction transaction, byte[] hash, AccountStore accountStore, DynamicPropertiesStore dynamicPropertiesStore) throws PermissionException, SignatureException, SignatureFormatException {
        Protocol.Transaction.Contract contract = (Protocol.Transaction.Contract)transaction.getRawData().getContractList().get(0);
        int permissionId = contract.getPermissionId();
        byte[] owner = TransactionCapsule.getOwner(contract);
        AccountCapsule account = accountStore.get(owner);
        Protocol.Permission permission = null;
        if (account == null) {
            if (permissionId == 0) {
                permission = AccountCapsule.getDefaultPermission(ByteString.copyFrom((byte[])owner));
            }
            if (permissionId == 2) {
                permission = AccountCapsule.createDefaultActivePermission(ByteString.copyFrom((byte[])owner), dynamicPropertiesStore);
            }
        } else {
            permission = account.getPermissionById(permissionId);
        }
        if (permission == null) {
            throw new PermissionException("permission isn't exit");
        }
        TransactionCapsule.checkPermission(permissionId, permission, contract);
        long weight = TransactionCapsule.checkWeight(permission, transaction.getSignatureList(), hash, null);
        return weight >= permission.getThreshold();
    }

    public void resetResult() {
        if (this.getInstance().getRetCount() > 0) {
            this.transaction = this.getInstance().toBuilder().clearRet().build();
        }
    }

    public void setResult(TransactionResultCapsule transactionResultCapsule) {
        this.transaction = this.getInstance().toBuilder().addRet(transactionResultCapsule.getInstance()).build();
    }

    public void setReference(long blockNum, byte[] blockHash) {
        byte[] refBlockNum = ByteArray.fromLong((long)blockNum);
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setRefBlockHash(ByteString.copyFrom((byte[])ByteArray.subArray((byte[])blockHash, (int)8, (int)16))).setRefBlockBytes(ByteString.copyFrom((byte[])ByteArray.subArray((byte[])refBlockNum, (int)6, (int)8))).build();
        this.setRawData(rawData);
    }

    public long getExpiration() {
        return this.transaction.getRawData().getExpiration();
    }

    public void setExpiration(long expiration) {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setExpiration(expiration).build();
        this.setRawData(rawData);
    }

    public void setTimestamp() {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setTimestamp(System.currentTimeMillis()).build();
        this.setRawData(rawData);
    }

    public void setTimestamp(long timestamp) {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setTimestamp(timestamp).build();
        this.setRawData(rawData);
    }

    public long getTimestamp() {
        return this.transaction.getRawData().getTimestamp();
    }

    public void setFeeLimit(long feeLimit) {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setFeeLimit(feeLimit).build();
        this.setRawData(rawData);
    }

    public long getFeeLimit() {
        return this.transaction.getRawData().getFeeLimit();
    }

    @Deprecated
    public void createTransaction(Message message, Protocol.Transaction.Contract.ContractType contractType) {
        Protocol.Transaction.raw.Builder transactionBuilder = Protocol.Transaction.raw.newBuilder().addContract(Protocol.Transaction.Contract.newBuilder().setType(contractType).setParameter(Any.pack((Message)message)).build());
        this.transaction = Protocol.Transaction.newBuilder().setRawData(transactionBuilder.build()).build();
    }

    public Sha256Hash getMerkleHash() {
        byte[] transBytes = this.transaction.toByteArray();
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transBytes);
    }

    private Sha256Hash getRawHash() {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])this.transaction.getRawData().toByteArray());
    }

    public void sign(byte[] privateKey) {
        SignInterface cryptoEngine = SignUtils.fromPrivate((byte[])privateKey, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
        ByteString sig = ByteString.copyFrom((byte[])cryptoEngine.Base64toBytes(cryptoEngine.signHash(this.getTransactionId().getBytes())));
        this.transaction = this.transaction.toBuilder().addSignature(sig).build();
    }

    public void addSign(byte[] privateKey, AccountStore accountStore) throws PermissionException, SignatureException, SignatureFormatException {
        long weight;
        Protocol.Transaction.Contract contract = this.transaction.getRawData().getContract(0);
        int permissionId = contract.getPermissionId();
        byte[] owner = this.getOwnerAddress();
        AccountCapsule account = accountStore.get(owner);
        if (account == null) {
            throw new PermissionException("Account is not exist!");
        }
        Protocol.Permission permission = account.getPermissionById(permissionId);
        if (permission == null) {
            throw new PermissionException("permission isn't exit");
        }
        TransactionCapsule.checkPermission(permissionId, permission, contract);
        ArrayList<ByteString> approveList = new ArrayList<ByteString>();
        SignInterface cryptoEngine = SignUtils.fromPrivate((byte[])privateKey, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
        byte[] address = cryptoEngine.getAddress();
        if (this.transaction.getSignatureCount() > 0) {
            TransactionCapsule.checkWeight(permission, this.transaction.getSignatureList(), this.getTransactionId().getBytes(), approveList);
            if (approveList.contains(ByteString.copyFrom((byte[])address))) {
                throw new PermissionException(StringUtil.encode58Check((byte[])address) + " had signed!");
            }
        }
        if ((weight = TransactionCapsule.getWeight(permission, address)) == 0L) {
            throw new PermissionException(ByteArray.toHexString((byte[])privateKey) + "'s address is " + StringUtil.encode58Check((byte[])address) + " but it is not contained of permission.");
        }
        ByteString sig = ByteString.copyFrom((byte[])cryptoEngine.Base64toBytes(cryptoEngine.signHash(this.getTransactionId().getBytes())));
        this.transaction = this.transaction.toBuilder().addSignature(sig).build();
    }

    private static void checkPermission(int permissionId, Protocol.Permission permission, Protocol.Transaction.Contract contract) throws PermissionException {
        if (permissionId != 0) {
            if (permission.getType() != Protocol.Permission.PermissionType.Active) {
                throw new PermissionException("Permission type is error");
            }
            if (!WalletUtil.checkPermissionOperations(permission, contract)) {
                throw new PermissionException("Permission denied");
            }
        }
    }

    public boolean validatePubSignature(AccountStore accountStore, DynamicPropertiesStore dynamicPropertiesStore) throws ValidateSignatureException {
        if (!this.isVerified) {
            if (this.transaction.getSignatureCount() <= 0 || this.transaction.getRawData().getContractCount() <= 0) {
                throw new ValidateSignatureException("miss sig or contract");
            }
            if (this.transaction.getSignatureCount() > dynamicPropertiesStore.getTotalSignNum()) {
                throw new ValidateSignatureException("too many signatures");
            }
            byte[] hash = this.getTransactionId().getBytes();
            try {
                if (!TransactionCapsule.validateSignature(this.transaction, hash, accountStore, dynamicPropertiesStore)) {
                    this.isVerified = false;
                    throw new ValidateSignatureException("sig error");
                }
            }
            catch (SignatureException | PermissionException | SignatureFormatException e) {
                this.isVerified = false;
                throw new ValidateSignatureException(e.getMessage());
            }
            this.isVerified = true;
        }
        return true;
    }

    public boolean validateSignature(AccountStore accountStore, DynamicPropertiesStore dynamicPropertiesStore) throws ValidateSignatureException {
        if (!this.isVerified) {
            Protocol.Transaction.Contract contract = this.getInstance().getRawData().getContract(0);
            if (contract.getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) {
                this.validatePubSignature(accountStore, dynamicPropertiesStore);
            } else {
                byte[] owner = this.getOwnerAddress();
                if (!ArrayUtils.isEmpty((byte[])owner)) {
                    this.validatePubSignature(accountStore, dynamicPropertiesStore);
                } else if (this.transaction.getSignatureCount() > 0) {
                    throw new ValidateSignatureException("there should be no signatures signed by transparent address when transfer from shielded address");
                }
            }
            this.isVerified = true;
        }
        return true;
    }

    public Sha256Hash getTransactionId() {
        if (this.id == null) {
            this.id = this.getRawHash();
        }
        return this.id;
    }

    private void setRawData(Protocol.Transaction.raw rawData) {
        this.transaction = this.transaction.toBuilder().setRawData(rawData).build();
        this.id = null;
    }

    @Override
    public byte[] getData() {
        return this.transaction.toByteArray();
    }

    public long getSerializedSize() {
        return this.transaction.getSerializedSize();
    }

    public long computeTrxSizeForBlockMessage() {
        return CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.transaction);
    }

    public long getResultSerializedSize() {
        long size = 0L;
        for (Protocol.Transaction.Result result : this.transaction.getRetList()) {
            size += (long)result.getSerializedSize();
        }
        return size;
    }

    public long getResultSizeWithMaxContractRet() {
        long size = 0L;
        for (Protocol.Transaction.Result result : this.transaction.getRetList()) {
            size += (long)result.toBuilder().clearContractRet().build().getSerializedSize() + 2L;
        }
        return size;
    }

    @Override
    public Protocol.Transaction getInstance() {
        return this.transaction;
    }

    public String toString() {
        StringBuilder toStringBuff = new StringBuilder();
        toStringBuff.append("TransactionCapsule \n[ ");
        toStringBuff.append("hash=").append(this.getTransactionId()).append("\n");
        AtomicInteger i = new AtomicInteger();
        if (!this.getInstance().getRawData().getContractList().isEmpty()) {
            toStringBuff.append("contract list:{ ");
            this.getInstance().getRawData().getContractList().forEach(contract -> {
                toStringBuff.append("[" + i + "] ").append("type: ").append(contract.getType()).append("\n");
                toStringBuff.append("from address=").append(TransactionCapsule.getOwner(contract)).append("\n");
                toStringBuff.append("to address=").append(TransactionCapsule.getToAddress(contract)).append("\n");
                if (contract.getType().equals((Object)Protocol.Transaction.Contract.ContractType.TransferContract)) {
                    try {
                        BalanceContract.TransferContract transferContract = (BalanceContract.TransferContract)contract.getParameter().unpack(BalanceContract.TransferContract.class);
                        toStringBuff.append("transfer amount=").append(transferContract.getAmount()).append("\n");
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                } else if (contract.getType().equals((Object)Protocol.Transaction.Contract.ContractType.TransferAssetContract)) {
                    try {
                        AssetIssueContractOuterClass.TransferAssetContract transferAssetContract = (AssetIssueContractOuterClass.TransferAssetContract)contract.getParameter().unpack(AssetIssueContractOuterClass.TransferAssetContract.class);
                        toStringBuff.append("transfer asset=").append(transferAssetContract.getAssetName()).append("\n");
                        toStringBuff.append("transfer amount=").append(transferAssetContract.getAmount()).append("\n");
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                }
                if (this.transaction.getSignatureList().size() >= i.get() + 1) {
                    toStringBuff.append("sign=").append(TransactionCapsule.getBase64FromByteString(this.transaction.getSignature(i.getAndIncrement()))).append("\n");
                }
            });
            toStringBuff.append("}\n");
        } else {
            toStringBuff.append("contract list is empty\n");
        }
        toStringBuff.append("]");
        return toStringBuff.toString();
    }

    public void setResult(TransactionContext context) {
        this.setResultCode(context.getProgramResult().getResultCode());
    }

    public void setResultCode(Protocol.Transaction.Result.contractResult code2) {
        if (this.transaction.getRetCount() > 0) {
            Protocol.Transaction.Result ret = this.transaction.getRet(0).toBuilder().setContractRet(code2).build();
            this.transaction = this.transaction.toBuilder().setRet(0, ret).build();
            return;
        }
        Protocol.Transaction.Result ret = Protocol.Transaction.Result.newBuilder().setContractRet(code2).build();
        this.transaction = this.transaction.toBuilder().addRet(ret).build();
    }

    public Protocol.Transaction.Result.contractResult getContractResult() {
        if (this.transaction.getRetCount() > 0) {
            return this.transaction.getRet(0).getContractRet();
        }
        return null;
    }

    public Protocol.Transaction.Result.contractResult getContractRet() {
        if (this.transaction.getRetCount() <= 0) {
            return null;
        }
        return this.transaction.getRet(0).getContractRet();
    }

    public boolean isContractType() {
        try {
            Protocol.Transaction.Contract.ContractType type = this.getInstance().getRawData().getContract(0).getType();
            return type == Protocol.Transaction.Contract.ContractType.TriggerSmartContract || type == Protocol.Transaction.Contract.ContractType.CreateSmartContract;
        }
        catch (Exception ex) {
            logger.warn("check contract type failed, reason {}", (Object)ex.getMessage());
            return false;
        }
    }

    public BalanceContract.TransferContract getTransferContract() {
        try {
            return (BalanceContract.TransferContract)this.transaction.getRawData().getContract(0).getParameter().unpack(BalanceContract.TransferContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public void removeRedundantRet() {
        Protocol.Transaction tx = this.getInstance();
        ArrayList tmpList = new ArrayList(tx.getRetList());
        int contractCount = tx.getRawData().getContractCount();
        if (tx.getRetCount() > contractCount && contractCount > 0) {
            Protocol.Transaction.Builder transactionBuilder = tx.toBuilder().clearRet();
            for (int i = 0; i < contractCount; ++i) {
                Protocol.Transaction.Result result = (Protocol.Transaction.Result)tmpList.get(i);
                transactionBuilder.addRet(result);
            }
            this.transaction = transactionBuilder.build();
        }
    }

    public void checkExpiration(long nextSlotTime) throws TransactionExpirationException {
        if (this.getExpiration() < nextSlotTime) {
            throw new TransactionExpirationException(String.format("Transaction expiration time is %d, but next slot time is %d", this.getExpiration(), nextSlotTime));
        }
    }

    public void setVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public void setBlockNum(long blockNum) {
        this.blockNum = blockNum;
    }

    public long getBlockNum() {
        return this.blockNum;
    }

    public TransactionTrace getTrxTrace() {
        return this.trxTrace;
    }

    public void setTrxTrace(TransactionTrace trxTrace) {
        this.trxTrace = trxTrace;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public boolean isTransactionCreate() {
        return this.isTransactionCreate;
    }

    public void setTransactionCreate(boolean isTransactionCreate) {
        this.isTransactionCreate = isTransactionCreate;
    }

    public boolean isInBlock() {
        return this.isInBlock;
    }

    public void setInBlock(boolean isInBlock) {
        this.isInBlock = isInBlock;
    }
}

