/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.protos.contract.ShieldContract;

public class PedersenHashCapsule
implements ProtoCapsule<ShieldContract.PedersenHash> {
    private static final Logger logger = LoggerFactory.getLogger(PedersenHashCapsule.class);
    private ShieldContract.PedersenHash pedersenHash;

    public PedersenHashCapsule() {
        this.pedersenHash = ShieldContract.PedersenHash.getDefaultInstance();
    }

    public PedersenHashCapsule(ShieldContract.PedersenHash pedersenHash) {
        this.pedersenHash = pedersenHash;
    }

    public PedersenHashCapsule(byte[] data) {
        try {
            this.pedersenHash = ShieldContract.PedersenHash.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static PedersenHashCapsule combine(ShieldContract.PedersenHash a, ShieldContract.PedersenHash b, int depth) throws ZksnarkException {
        byte[] res = new byte[32];
        JLibrustzcash.librustzcashMerkleHash(new LibrustzcashParam.MerkleHashParams(depth, a.getContent().toByteArray(), b.getContent().toByteArray(), res));
        PedersenHashCapsule pedersenHashCapsule = new PedersenHashCapsule();
        pedersenHashCapsule.setContent(ByteString.copyFrom((byte[])res));
        return pedersenHashCapsule;
    }

    public static PedersenHashCapsule uncommitted() throws ZksnarkException {
        byte[] res = new byte[32];
        JLibrustzcash.librustzcashTreeUncommitted(res);
        PedersenHashCapsule compressCapsule = new PedersenHashCapsule();
        compressCapsule.setContent(ByteString.copyFrom((byte[])res));
        return compressCapsule;
    }

    public static void main(String[] args) {
        try {
            byte[] a = ByteArray.fromHexString((String)"05655316a07e6ec8c9769af54ef98b30667bfb6302b32987d552227dae86a087");
            byte[] b = ByteArray.fromHexString((String)"06041357de59ba64959d1b60f93de24dfe5ea1e26ed9e8a73d35b225a1845ba7");
            ShieldContract.PedersenHash sa = ShieldContract.PedersenHash.newBuilder().setContent(ByteString.copyFrom((byte[])a)).build();
            ShieldContract.PedersenHash sb = ShieldContract.PedersenHash.newBuilder().setContent(ByteString.copyFrom((byte[])b)).build();
            ShieldContract.PedersenHash result = PedersenHashCapsule.combine(sa, sb, 25).getInstance();
            System.out.println(ByteArray.toHexString((byte[])result.getContent().toByteArray()));
        }
        catch (ZksnarkException e) {
            e.printStackTrace();
        }
    }

    public ByteString getContent() {
        return this.pedersenHash.getContent();
    }

    public void setContent(ByteString content) {
        this.pedersenHash = ShieldContract.PedersenHash.newBuilder().setContent(content).build();
    }

    @Override
    public byte[] getData() {
        return this.pedersenHash.toByteArray();
    }

    @Override
    public ShieldContract.PedersenHash getInstance() {
        return this.pedersenHash;
    }

    public boolean isPresent() {
        return !this.pedersenHash.getContent().isEmpty();
    }
}

