/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.MarketOrderCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.MarketOrderStore;
import org.tron.core.store.MarketPairPriceToOrderStore;
import org.tron.protos.Protocol;

public class MarketOrderIdListCapsule
implements ProtoCapsule<Protocol.MarketOrderIdList> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.MarketOrderIdList orderIdList;

    public MarketOrderIdListCapsule(Protocol.MarketOrderIdList orderIdList) {
        this.orderIdList = orderIdList;
    }

    public MarketOrderIdListCapsule(byte[] data) {
        try {
            this.orderIdList = Protocol.MarketOrderIdList.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public MarketOrderIdListCapsule() {
        this.orderIdList = Protocol.MarketOrderIdList.newBuilder().setHead(ByteString.copyFrom((byte[])new byte[0])).setTail(ByteString.copyFrom((byte[])new byte[0])).build();
    }

    public MarketOrderIdListCapsule(byte[] head, byte[] tail) {
        this.orderIdList = Protocol.MarketOrderIdList.newBuilder().setHead(ByteString.copyFrom((byte[])head)).setTail(ByteString.copyFrom((byte[])tail)).build();
    }

    public boolean isOrderExists(byte[] orderId, MarketOrderStore orderStore) throws ItemNotFoundException {
        if (orderId.length == 0) {
            return false;
        }
        if (this.isOrderEmpty()) {
            return false;
        }
        boolean found = false;
        byte[] currentOrderId = this.getHead();
        while (currentOrderId.length != 0) {
            if (Arrays.equals(orderId, currentOrderId)) {
                found = true;
                break;
            }
            MarketOrderCapsule currentCapsule = orderStore.get(orderId);
            if (currentCapsule.isNextNull()) break;
            currentOrderId = currentCapsule.getNext();
        }
        return found;
    }

    public void removeOrder(MarketOrderCapsule currentCapsule, MarketOrderStore marketOrderStore, byte[] pairPriceKey, MarketPairPriceToOrderStore pairPriceToOrderStore) throws ItemNotFoundException {
        MarketOrderCapsule preCapsule = currentCapsule.getPrevCapsule(marketOrderStore);
        MarketOrderCapsule nextCapsule = currentCapsule.getNextCapsule(marketOrderStore);
        if (preCapsule != null) {
            if (nextCapsule != null) {
                preCapsule.setNext(currentCapsule.getNext());
            } else {
                preCapsule.setNext(new byte[0]);
            }
            marketOrderStore.put(preCapsule.getID().toByteArray(), preCapsule);
        } else {
            if (nextCapsule != null) {
                this.setHead(currentCapsule.getNext());
            } else {
                this.setHead(new byte[0]);
            }
            pairPriceToOrderStore.put(pairPriceKey, this);
        }
        if (nextCapsule != null) {
            if (preCapsule != null) {
                nextCapsule.setPrev(currentCapsule.getPrev());
            } else {
                nextCapsule.setPrev(new byte[0]);
            }
            marketOrderStore.put(nextCapsule.getID().toByteArray(), nextCapsule);
        } else {
            if (preCapsule != null) {
                this.setTail(currentCapsule.getPrev());
            } else {
                this.setTail(new byte[0]);
            }
            pairPriceToOrderStore.put(pairPriceKey, this);
        }
        currentCapsule.setPrev(new byte[0]);
        currentCapsule.setNext(new byte[0]);
        marketOrderStore.put(currentCapsule.getID().toByteArray(), currentCapsule);
    }

    public void setHead(byte[] head) {
        this.orderIdList = this.orderIdList.toBuilder().setHead(ByteString.copyFrom((byte[])head)).build();
    }

    public byte[] getHead() {
        return this.orderIdList.getHead().toByteArray();
    }

    public byte[] getTail() {
        return this.orderIdList.getTail().toByteArray();
    }

    public void setTail(byte[] tail) {
        this.orderIdList = this.orderIdList.toBuilder().setTail(ByteString.copyFrom((byte[])tail)).build();
    }

    public boolean isOrderEmpty() {
        return this.getHead() == null || this.getHead().length == 0;
    }

    public void addOrder(MarketOrderCapsule currentCapsule, MarketOrderStore orderStore) throws ItemNotFoundException {
        byte[] orderId = currentCapsule.getID().toByteArray();
        if (this.isOrderEmpty()) {
            this.setHead(orderId);
            this.setTail(orderId);
        } else {
            byte[] tailId = this.getTail();
            MarketOrderCapsule tailCapsule = orderStore.get(tailId);
            tailCapsule.setNext(orderId);
            orderStore.put(tailId, tailCapsule);
            currentCapsule.setPrev(tailId);
            orderStore.put(orderId, currentCapsule);
            this.setTail(orderId);
        }
    }

    public MarketOrderCapsule getHeadOrder(MarketOrderStore marketOrderStore) throws ItemNotFoundException {
        if (this.isOrderEmpty()) {
            return null;
        }
        return marketOrderStore.get(this.getHead());
    }

    public MarketOrderCapsule getOrderByIndex(int index, MarketOrderStore marketOrderStore) throws ItemNotFoundException {
        if (this.isOrderEmpty()) {
            return null;
        }
        MarketOrderCapsule current = this.getHeadOrder(marketOrderStore);
        int count = 0;
        while (current != null) {
            if (count == index) {
                return current;
            }
            ++count;
            if (current.isNextNull()) {
                return null;
            }
            current = marketOrderStore.get(current.getNext());
        }
        return null;
    }

    public int getOrderSize(MarketOrderStore marketOrderStore) throws ItemNotFoundException {
        if (this.isOrderEmpty()) {
            return 0;
        }
        MarketOrderCapsule head = marketOrderStore.get(this.getHead());
        int size = 1;
        while (!head.isNextNull()) {
            ++size;
            head = marketOrderStore.get(head.getNext());
        }
        return size;
    }

    @Override
    public byte[] getData() {
        return this.orderIdList.toByteArray();
    }

    @Override
    public Protocol.MarketOrderIdList getInstance() {
        return this.orderIdList;
    }

    public List<MarketOrderCapsule> getAllOrder(MarketOrderStore orderStore, long limit) throws ItemNotFoundException {
        ArrayList<MarketOrderCapsule> result = new ArrayList<MarketOrderCapsule>();
        long count = 0L;
        byte[] orderId = this.getHead();
        if (!ByteArray.isEmpty((byte[])orderId)) {
            for (MarketOrderCapsule makerOrderCapsule = (MarketOrderCapsule)orderStore.getUnchecked(orderId); makerOrderCapsule != null; makerOrderCapsule = makerOrderCapsule.getNextCapsule(orderStore)) {
                result.add(makerOrderCapsule);
                if (++count <= limit) continue;
                break;
            }
        }
        return result;
    }
}

