/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.math.Maths;

public class ExchangeProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private long supply;
    private final boolean useStrictMath;

    public ExchangeProcessor(long supply, boolean useStrictMath) {
        this.supply = supply;
        this.useStrictMath = useStrictMath;
    }

    private long exchangeToSupply(long balance, long quant) {
        logger.debug("balance: " + balance);
        long newBalance = balance + quant;
        logger.debug("balance + quant: " + newBalance);
        double issuedSupply = (double)(-this.supply) * (1.0 - Maths.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4, this.useStrictMath));
        logger.debug("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchangeFromSupply(long balance, long supplyQuant) {
        this.supply -= supplyQuant;
        double exchangeBalance = (double)balance * (Maths.pow(1.0 + (double)supplyQuant / (double)this.supply, 2000.0, this.useStrictMath) - 1.0);
        logger.debug("exchangeBalance: " + exchangeBalance);
        return (long)exchangeBalance;
    }

    public long exchange(long sellTokenBalance, long buyTokenBalance, long sellTokenQuant) {
        long relay = this.exchangeToSupply(sellTokenBalance, sellTokenQuant);
        return this.exchangeFromSupply(buyTokenBalance, relay);
    }
}

