/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import org.tron.common.utils.ByteUtil;
import org.tron.core.exception.ZksnarkException;

public class JLibsodiumParam {
    public static void validNull(byte[] value) throws ZksnarkException {
        if (ByteUtil.isNullOrZeroArray((byte[])value)) {
            throw new ZksnarkException("param is null");
        }
    }

    public static void validValueParams(long value) throws ZksnarkException {
        if (value < 0L) {
            throw new ZksnarkException("Value should be non-negative.");
        }
    }

    public static void validParamLength(byte[] value, int length) throws ZksnarkException {
        JLibsodiumParam.validNull(value);
        if (value.length != length) {
            throw new ZksnarkException("param length must be " + length);
        }
    }

    public static class Chacha20Poly1305IetfEncryptParams
    implements ValidParam {
        private byte[] c;
        private long[] cLenP;
        private byte[] m;
        private long mLen;
        private byte[] ad;
        private long adLen;
        private byte[] nSec;
        private byte[] nPub;
        private byte[] k;

        public Chacha20Poly1305IetfEncryptParams(byte[] c, long[] cLenP, byte[] m, long mLen, byte[] ad, long adLen, byte[] nSec, byte[] nPub, byte[] k) throws ZksnarkException {
            this.c = c;
            this.cLenP = cLenP;
            this.m = m;
            this.mLen = mLen;
            this.ad = ad;
            this.adLen = adLen;
            this.nSec = nSec;
            this.nPub = nPub;
            this.k = k;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            JLibsodiumParam.validParamLength(this.nPub, 12);
            JLibsodiumParam.validParamLength(this.k, 32);
        }

        public void setC(byte[] c) {
            this.c = c;
        }

        public byte[] getC() {
            return this.c;
        }

        public void setCLenP(long[] cLenP) {
            this.cLenP = cLenP;
        }

        public long[] getCLenP() {
            return this.cLenP;
        }

        public void setM(byte[] m) {
            this.m = m;
        }

        public byte[] getM() {
            return this.m;
        }

        public void setMLen(long mLen) {
            this.mLen = mLen;
        }

        public long getMLen() {
            return this.mLen;
        }

        public void setAd(byte[] ad) {
            this.ad = ad;
        }

        public byte[] getAd() {
            return this.ad;
        }

        public void setAdLen(long adLen) {
            this.adLen = adLen;
        }

        public long getAdLen() {
            return this.adLen;
        }

        public void setNSec(byte[] nSec) {
            this.nSec = nSec;
        }

        public byte[] getNSec() {
            return this.nSec;
        }

        public void setNPub(byte[] nPub) {
            this.nPub = nPub;
        }

        public byte[] getNPub() {
            return this.nPub;
        }

        public void setK(byte[] k) {
            this.k = k;
        }

        public byte[] getK() {
            return this.k;
        }
    }

    public static class Chacha20poly1305IetfDecryptParams
    implements ValidParam {
        private byte[] m;
        private long[] mLenP;
        private byte[] nSec;
        private byte[] c;
        private long cLen;
        private byte[] ad;
        private long adLen;
        private byte[] nPub;
        private byte[] k;

        public Chacha20poly1305IetfDecryptParams(byte[] m, long[] mLenP, byte[] nSec, byte[] c, long cLen, byte[] ad, long adLen, byte[] nPub, byte[] k) throws ZksnarkException {
            this.m = m;
            this.mLenP = mLenP;
            this.nSec = nSec;
            this.c = c;
            this.cLen = cLen;
            this.ad = ad;
            this.adLen = adLen;
            this.nPub = nPub;
            this.k = k;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            JLibsodiumParam.validParamLength(this.nPub, 12);
            JLibsodiumParam.validParamLength(this.k, 32);
        }

        public void setM(byte[] m) {
            this.m = m;
        }

        public byte[] getM() {
            return this.m;
        }

        public void setMLenP(long[] mLenP) {
            this.mLenP = mLenP;
        }

        public long[] getMLenP() {
            return this.mLenP;
        }

        public void setNSec(byte[] nSec) {
            this.nSec = nSec;
        }

        public byte[] getNSec() {
            return this.nSec;
        }

        public void setC(byte[] c) {
            this.c = c;
        }

        public byte[] getC() {
            return this.c;
        }

        public void setCLen(long cLen) {
            this.cLen = cLen;
        }

        public long getCLen() {
            return this.cLen;
        }

        public void setAd(byte[] ad) {
            this.ad = ad;
        }

        public byte[] getAd() {
            return this.ad;
        }

        public void setAdLen(long adLen) {
            this.adLen = adLen;
        }

        public long getAdLen() {
            return this.adLen;
        }

        public void setNPub(byte[] nPub) {
            this.nPub = nPub;
        }

        public byte[] getNPub() {
            return this.nPub;
        }

        public void setK(byte[] k) {
            this.k = k;
        }

        public byte[] getK() {
            return this.k;
        }
    }

    public static class Black2bSaltPersonalParams
    implements ValidParam {
        private byte[] out;
        private int outLen;
        private byte[] in;
        private long inLen;
        private byte[] key;
        private int keyLen;
        private byte[] salt;
        private byte[] personal;

        public Black2bSaltPersonalParams(byte[] out, int outLen, byte[] in, long inLen, byte[] key, int keyLen, byte[] salt, byte[] personal) throws ZksnarkException {
            this.out = out;
            this.outLen = outLen;
            this.in = in;
            this.inLen = inLen;
            this.key = key;
            this.keyLen = keyLen;
            this.salt = salt;
            this.personal = personal;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            if (this.out.length != this.outLen || (long)this.in.length != this.inLen) {
                throw new ZksnarkException("out.length is not equal to outlen or in.length is not equal to inlen");
            }
            JLibsodiumParam.validParamLength(this.out, 32);
            JLibsodiumParam.validParamLength(this.personal, 16);
        }

        public void setOut(byte[] out) {
            this.out = out;
        }

        public byte[] getOut() {
            return this.out;
        }

        public void setOutLen(int outLen) {
            this.outLen = outLen;
        }

        public int getOutLen() {
            return this.outLen;
        }

        public void setIn(byte[] in) {
            this.in = in;
        }

        public byte[] getIn() {
            return this.in;
        }

        public void setInLen(long inLen) {
            this.inLen = inLen;
        }

        public long getInLen() {
            return this.inLen;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setKeyLen(int keyLen) {
            this.keyLen = keyLen;
        }

        public int getKeyLen() {
            return this.keyLen;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void setPersonal(byte[] personal) {
            this.personal = personal;
        }

        public byte[] getPersonal() {
            return this.personal;
        }
    }

    public static class Blake2bFinalParams
    implements ValidParam {
        private long state;
        private byte[] out;
        private int outLen;

        public Blake2bFinalParams(long state, byte[] out, int outLen) throws ZksnarkException {
            this.state = state;
            this.out = out;
            this.outLen = outLen;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            JLibsodiumParam.validValueParams(this.state);
            if (this.out.length != this.outLen || this.out.length != 11 && this.out.length != 64) {
                throw new ZksnarkException("param length must be 11 or 64");
            }
        }

        public void setState(long state) {
            this.state = state;
        }

        public long getState() {
            return this.state;
        }

        public void setOut(byte[] out) {
            this.out = out;
        }

        public byte[] getOut() {
            return this.out;
        }

        public void setOutLen(int outLen) {
            this.outLen = outLen;
        }

        public int getOutLen() {
            return this.outLen;
        }
    }

    public static class Blake2bUpdateParams
    implements ValidParam {
        private long state;
        private byte[] in;
        private long inLen;

        public Blake2bUpdateParams(long state, byte[] in, long inLen) throws ZksnarkException {
            this.state = state;
            this.in = in;
            this.inLen = inLen;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            JLibsodiumParam.validValueParams(this.state);
            if ((long)this.in.length != this.inLen || this.in.length != 33 && this.in.length != 34) {
                throw new ZksnarkException("param length must be 33 or 34");
            }
        }

        public void setState(long state) {
            this.state = state;
        }

        public long getState() {
            return this.state;
        }

        public void setIn(byte[] in) {
            this.in = in;
        }

        public byte[] getIn() {
            return this.in;
        }

        public void setInLen(long inLen) {
            this.inLen = inLen;
        }

        public long getInLen() {
            return this.inLen;
        }
    }

    public static class Blake2bInitSaltPersonalParams
    implements ValidParam {
        private long state;
        private byte[] key;
        private int keyLen;
        private int outLen;
        private byte[] salt;
        private byte[] personal;

        public Blake2bInitSaltPersonalParams(long state, byte[] key, int keyLen, int outLen, byte[] salt, byte[] personal) throws ZksnarkException {
            this.state = state;
            this.key = key;
            this.keyLen = keyLen;
            this.outLen = outLen;
            this.salt = salt;
            this.personal = personal;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            JLibsodiumParam.validValueParams(this.state);
            JLibsodiumParam.validParamLength(this.personal, 16);
        }

        public void setState(long state) {
            this.state = state;
        }

        public long getState() {
            return this.state;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setKeyLen(int keyLen) {
            this.keyLen = keyLen;
        }

        public int getKeyLen() {
            return this.keyLen;
        }

        public void setOutLen(int outLen) {
            this.outLen = outLen;
        }

        public int getOutLen() {
            return this.outLen;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public void setPersonal(byte[] personal) {
            this.personal = personal;
        }

        public byte[] getPersonal() {
            return this.personal;
        }
    }

    static interface ValidParam {
        public void valid() throws ZksnarkException;
    }
}

