/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignUtils;
import org.tron.common.utils.ByteArray;

public class LocalWitnesses {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private List<String> privateKeys = Lists.newArrayList();
    private byte[] witnessAccountAddress;

    public LocalWitnesses() {
    }

    public LocalWitnesses(String privateKey) {
        this.addPrivateKeys(privateKey);
    }

    public LocalWitnesses(List<String> privateKeys) {
        this.setPrivateKeys(privateKeys);
    }

    public byte[] getWitnessAccountAddress(boolean isECKeyCryptoEngine) {
        if (this.witnessAccountAddress == null) {
            byte[] privateKey = ByteArray.fromHexString((String)this.getPrivateKey());
            SignInterface cryptoEngine = SignUtils.fromPrivate((byte[])privateKey, (boolean)isECKeyCryptoEngine);
            this.witnessAccountAddress = cryptoEngine.getAddress();
        }
        return this.witnessAccountAddress;
    }

    public void setWitnessAccountAddress(byte[] localWitnessAccountAddress) {
        this.witnessAccountAddress = localWitnessAccountAddress;
    }

    public void initWitnessAccountAddress(boolean isECKeyCryptoEngine) {
        if (this.witnessAccountAddress == null) {
            byte[] privateKey = ByteArray.fromHexString((String)this.getPrivateKey());
            SignInterface ecKey = SignUtils.fromPrivate((byte[])privateKey, (boolean)isECKeyCryptoEngine);
            this.witnessAccountAddress = ecKey.getAddress();
        }
    }

    public void setPrivateKeys(List<String> privateKeys) {
        if (CollectionUtils.isEmpty(privateKeys)) {
            return;
        }
        for (String privateKey : privateKeys) {
            this.validate(privateKey);
        }
        this.privateKeys = privateKeys;
    }

    private void validate(String privateKey) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)privateKey, (CharSequence)"0X")) {
            privateKey = privateKey.substring(2);
        }
        if (StringUtils.isNotBlank((CharSequence)privateKey) && privateKey.length() != 64) {
            throw new IllegalArgumentException(String.format("private key must be %d-bits hex string, actual: %d", 64, privateKey.length()));
        }
    }

    public void addPrivateKeys(String privateKey) {
        this.validate(privateKey);
        this.privateKeys.add(privateKey);
    }

    public String getPrivateKey() {
        if (CollectionUtils.isEmpty(this.privateKeys)) {
            logger.warn("PrivateKey is null.");
            return null;
        }
        return this.privateKeys.get(0);
    }

    public byte[] getPublicKey() {
        if (CollectionUtils.isEmpty(this.privateKeys)) {
            logger.warn("PrivateKey is null.");
            return null;
        }
        byte[] privateKey = ByteArray.fromHexString((String)this.getPrivateKey());
        ECKey ecKey = ECKey.fromPrivate((byte[])privateKey);
        return ecKey.getAddress();
    }

    public List<String> getPrivateKeys() {
        return this.privateKeys;
    }
}

