/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.utils;

import java.math.BigInteger;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.store.DelegationStore;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.Protocol;

public class VoteRewardUtil {
    private VoteRewardUtil() {
    }

    public static void withdrawReward(byte[] address, Repository repository) {
        AccountCapsule account;
        if (!VMConfig.allowTvmVote()) {
            return;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        long beginCycle = repository.getBeginCycle(address);
        long endCycle = repository.getEndCycle(address);
        long currentCycle = repository.getDynamicPropertiesStore().getCurrentCycleNumber();
        long reward = 0L;
        if (beginCycle > currentCycle || accountCapsule == null) {
            return;
        }
        if (beginCycle == currentCycle && (account = repository.getAccountVote(beginCycle, address)) != null) {
            return;
        }
        if (beginCycle + 1L == endCycle && beginCycle < currentCycle) {
            account = repository.getAccountVote(beginCycle, address);
            if (account != null) {
                reward = VoteRewardUtil.computeReward(beginCycle, endCycle, account, repository);
                VoteRewardUtil.adjustAllowance(address, reward, repository);
                reward = 0L;
            }
            ++beginCycle;
        }
        endCycle = currentCycle;
        if (CollectionUtils.isEmpty((Collection)accountCapsule.getVotesList())) {
            repository.updateBeginCycle(address, endCycle + 1L);
            return;
        }
        if (beginCycle < endCycle) {
            VoteRewardUtil.adjustAllowance(address, reward += VoteRewardUtil.computeReward(beginCycle, endCycle, accountCapsule, repository), repository);
        }
        repository.updateBeginCycle(address, endCycle);
        repository.updateEndCycle(address, endCycle + 1L);
        repository.updateAccountVote(address, endCycle, accountCapsule);
    }

    public static long queryReward(byte[] address, Repository repository) {
        if (!VMConfig.allowTvmVote()) {
            return 0L;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        long beginCycle = repository.getBeginCycle(address);
        long endCycle = repository.getEndCycle(address);
        long currentCycle = repository.getDynamicPropertiesStore().getCurrentCycleNumber();
        long reward = 0L;
        if (accountCapsule == null) {
            return 0L;
        }
        if (beginCycle > currentCycle) {
            return accountCapsule.getAllowance();
        }
        if (beginCycle + 1L == endCycle && beginCycle < currentCycle) {
            AccountCapsule account = repository.getAccountVote(beginCycle, address);
            if (account != null) {
                reward = VoteRewardUtil.computeReward(beginCycle, endCycle, account, repository);
            }
            ++beginCycle;
        }
        endCycle = currentCycle;
        if (CollectionUtils.isEmpty((Collection)accountCapsule.getVotesList())) {
            return reward + accountCapsule.getAllowance();
        }
        if (beginCycle < endCycle) {
            reward += VoteRewardUtil.computeReward(beginCycle, endCycle, accountCapsule, repository);
        }
        return reward + accountCapsule.getAllowance();
    }

    private static long computeReward(long beginCycle, long endCycle, AccountCapsule accountCapsule, Repository repository) {
        if (beginCycle >= endCycle) {
            return 0L;
        }
        long reward = 0L;
        for (Protocol.Vote vote : accountCapsule.getVotesList()) {
            byte[] srAddress = vote.getVoteAddress().toByteArray();
            BigInteger beginVi = repository.getDelegationStore().getWitnessVi(beginCycle - 1L, srAddress);
            BigInteger endVi = repository.getDelegationStore().getWitnessVi(endCycle - 1L, srAddress);
            BigInteger deltaVi = endVi.subtract(beginVi);
            if (deltaVi.signum() <= 0) continue;
            long userVote = vote.getVoteCount();
            reward += deltaVi.multiply(BigInteger.valueOf(userVote)).divide(DelegationStore.DECIMAL_OF_VI_REWARD).longValue();
        }
        return reward;
    }

    private static void adjustAllowance(byte[] address, long amount, Repository repository) {
        if (amount <= 0L) {
            return;
        }
        AccountCapsule accountCapsule = repository.getAccount(address);
        long allowance = accountCapsule.getAllowance();
        accountCapsule.setAllowance(allowance + amount);
        repository.updateAccount(accountCapsule.createDbKey(), accountCapsule);
    }
}

