/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program.invoke;

import com.google.protobuf.ByteString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.tron.common.crypto.Hash;
import org.tron.common.crypto.SignUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.store.StoreFactory;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.repository.RepositoryImpl;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class ProgramInvokeMockImpl
implements ProgramInvoke {
    private final byte[] contractAddress = Hex.decode((String)"41471fd3ad3e9eeadeec4608b92d16ce6b500704cc");
    private byte[] msgData;
    private Repository deposit;
    private byte[] ownerAddress = Hex.decode((String)"41cd2a3d9f938e13cd947ec05abc7fe734df8dd826");
    private boolean isConstantCall;
    private boolean isStaticCall;
    private long energyLimit = 50L;

    public ProgramInvokeMockImpl(byte[] msgDataRaw) {
        this();
        this.msgData = Arrays.clone((byte[])msgDataRaw);
    }

    public ProgramInvokeMockImpl() {
        this.deposit = RepositoryImpl.createRoot(null);
        this.deposit.createAccount(this.ownerAddress, Protocol.AccountType.Normal);
        this.deposit.createAccount(this.contractAddress, Protocol.AccountType.Contract);
        this.deposit.createContract(this.contractAddress, new ContractCapsule(SmartContractOuterClass.SmartContract.newBuilder().setContractAddress(ByteString.copyFrom((byte[])this.contractAddress)).build()));
        this.deposit.saveCode(this.contractAddress, Hex.decode((String)"385E60076000396000605f556014600054601e60205463abcddcba6040545b51602001600a5254516040016014525451606001601e5254516080016028525460a052546016604860003960166000f26000603f556103e75660005460005360200235"));
    }

    public ProgramInvokeMockImpl(byte[] op, byte[] opAddress) {
        this(null, op, opAddress);
    }

    public ProgramInvokeMockImpl(StoreFactory storeFactory, byte[] op, byte[] opAddress) {
        this.deposit = RepositoryImpl.createRoot(storeFactory);
        this.deposit.createAccount(opAddress, Protocol.AccountType.Normal);
        this.deposit.createAccount(opAddress, Protocol.AccountType.Contract);
        this.deposit.createContract(opAddress, new ContractCapsule(SmartContractOuterClass.SmartContract.newBuilder().setContractAddress(ByteString.copyFrom((byte[])op)).build()));
        this.deposit.saveCode(opAddress, op);
    }

    public ProgramInvokeMockImpl(boolean defaults) {
    }

    @Override
    public DataWord getContractAddress() {
        return new DataWord(this.contractAddress);
    }

    @Override
    public DataWord getBalance() {
        byte[] balance = Hex.decode((String)"0DE0B6B3A7640000");
        return new DataWord(balance);
    }

    @Override
    public DataWord getOriginAddress() {
        byte[] cowPrivKey = Hash.sha3((byte[])"horse".getBytes());
        byte[] addr = SignUtils.fromPrivate((byte[])cowPrivKey, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine()).getAddress();
        return new DataWord(addr);
    }

    @Override
    public DataWord getCallerAddress() {
        byte[] cowPrivKey = Hash.sha3((byte[])"monkey".getBytes());
        byte[] addr = SignUtils.fromPrivate((byte[])cowPrivKey, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine()).getAddress();
        return new DataWord(addr);
    }

    public DataWord getMinEnergyPrice() {
        byte[] minEnergyPrice = Hex.decode((String)"09184e72a000");
        return new DataWord(minEnergyPrice);
    }

    @Override
    public DataWord getCallValue() {
        return this.getBalance();
    }

    @Override
    public DataWord getTokenValue() {
        return null;
    }

    @Override
    public DataWord getTokenId() {
        return null;
    }

    @Override
    public DataWord getDataValue(DataWord indexData) {
        byte[] data = new byte[32];
        int index = indexData.value().intValue();
        int size = 32;
        if (this.msgData == null) {
            return new DataWord(data);
        }
        if (index > this.msgData.length) {
            return new DataWord(data);
        }
        if (index + 32 > this.msgData.length) {
            size = this.msgData.length - index;
        }
        System.arraycopy(this.msgData, index, data, 0, size);
        return new DataWord(data);
    }

    @Override
    public DataWord getDataSize() {
        if (this.msgData == null || this.msgData.length == 0) {
            return new DataWord(new byte[32]);
        }
        int size = this.msgData.length;
        return new DataWord(size);
    }

    @Override
    public byte[] getDataCopy(DataWord offsetData, DataWord lengthData) {
        int offset = offsetData.value().intValue();
        int length = lengthData.value().intValue();
        byte[] data = new byte[length];
        if (this.msgData == null) {
            return data;
        }
        if (offset > this.msgData.length) {
            return data;
        }
        if (offset + length > this.msgData.length) {
            length = this.msgData.length - offset;
        }
        System.arraycopy(this.msgData, offset, data, 0, length);
        return data;
    }

    @Override
    public DataWord getPrevHash() {
        byte[] prevHash = Hex.decode((String)"961CB117ABA86D1E596854015A1483323F18883C2D745B0BC03E87F146D2BB1C");
        return new DataWord(prevHash);
    }

    @Override
    public DataWord getCoinbase() {
        byte[] coinBase = Hex.decode((String)"E559DE5527492BCB42EC68D07DF0742A98EC3F1E");
        return new DataWord(coinBase);
    }

    @Override
    public DataWord getTimestamp() {
        long timestamp = 1401421348L;
        return new DataWord(timestamp);
    }

    @Override
    public DataWord getNumber() {
        long number = 33L;
        return new DataWord(number);
    }

    @Override
    public DataWord getDifficulty() {
        byte[] difficulty = Hex.decode((String)"3ED290");
        return new DataWord(difficulty);
    }

    public void setOwnerAddress(byte[] ownerAddress) {
        this.ownerAddress = Arrays.clone((byte[])ownerAddress);
    }

    @Override
    public boolean isStaticCall() {
        return this.isStaticCall;
    }

    @Override
    public boolean isConstantCall() {
        return this.isConstantCall;
    }

    @Override
    public long getVmStartInUs() {
        return 0L;
    }

    @Override
    public long getEnergyLimit() {
        return this.energyLimit;
    }

    public void setEnergyLimit(long customizedEnergyLimit) {
        this.energyLimit = customizedEnergyLimit;
    }

    @Override
    public void setConstantCall() {
        this.isConstantCall = true;
    }

    @Override
    public boolean byTestingSuite() {
        return false;
    }

    @Override
    public Repository getDeposit() {
        return this.deposit;
    }

    @Override
    public int getCallDeep() {
        return 0;
    }

    @Override
    public long getVmShouldEndInUs() {
        return 0L;
    }
}

