/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.nativecontract.param.FreezeBalanceV2Param;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.contract.Common;

public class FreezeBalanceV2Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(FreezeBalanceV2Param param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        if (ownerCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        long frozenBalance = param.getFrozenBalance();
        if (frozenBalance <= 0L) {
            throw new ContractValidateException("FrozenBalance must be positive");
        }
        if (frozenBalance < 1000000L) {
            throw new ContractValidateException("FrozenBalance must be greater than or equal to 1 TRX");
        }
        if (frozenBalance > ownerCapsule.getBalance()) {
            throw new ContractValidateException("FrozenBalance must be less than or equal to accountBalance");
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: 
            case ENERGY: {
                break;
            }
            case TRON_POWER: {
                if (repo.getDynamicPropertiesStore().supportAllowNewResourceModel()) break;
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
            default: {
                if (repo.getDynamicPropertiesStore().supportAllowNewResourceModel()) {
                    throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY\u3001TRON_POWER]");
                }
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
    }

    public void execute(FreezeBalanceV2Param param, Repository repo) {
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        byte[] ownerAddress = param.getOwnerAddress();
        long frozenBalance = param.getFrozenBalance();
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(frozenBalance);
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                repo.addTotalNetWeight(newNetWeight - oldNetWeight);
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(frozenBalance);
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                repo.addTotalEnergyWeight(newEnergyWeight - oldEnergyWeight);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(frozenBalance);
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                repo.addTotalTronPowerWeight(newTPWeight - oldTPWeight);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
        long newBalance = accountCapsule.getBalance() - frozenBalance;
        accountCapsule.setBalance(newBalance);
        repo.updateAccount(accountCapsule.createDbKey(), accountCapsule);
    }
}

