/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.ContractStore;
import org.tron.core.vm.repository.RepositoryImpl;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class UpdateSettingContractActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UpdateSettingContractActuator() {
        super(Protocol.Transaction.Contract.ContractType.UpdateSettingContract, SmartContractOuterClass.UpdateSettingContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        ContractStore contractStore = this.chainBaseManager.getContractStore();
        try {
            SmartContractOuterClass.UpdateSettingContract usContract = (SmartContractOuterClass.UpdateSettingContract)this.any.unpack(SmartContractOuterClass.UpdateSettingContract.class);
            long newPercent = usContract.getConsumeUserResourcePercent();
            byte[] contractAddress = usContract.getContractAddress().toByteArray();
            ContractCapsule deployedContract = contractStore.get(contractAddress);
            contractStore.put(contractAddress, new ContractCapsule(deployedContract.getInstance().toBuilder().setConsumeUserResourcePercent(newPercent).build()));
            RepositoryImpl.removeLruCache(contractAddress);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        SmartContractOuterClass.UpdateSettingContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or contract store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        ContractStore contractStore = this.chainBaseManager.getContractStore();
        if (!this.any.is(SmartContractOuterClass.UpdateSettingContract.class)) {
            throw new ContractValidateException("contract type error, expected type [UpdateSettingContract], real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (SmartContractOuterClass.UpdateSettingContract)this.any.unpack(SmartContractOuterClass.UpdateSettingContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!DecodeUtil.addressValid((byte[])contract.getOwnerAddress().toByteArray())) {
            throw new ContractValidateException("Invalid address");
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        long newPercent = contract.getConsumeUserResourcePercent();
        if (newPercent > 100L || newPercent < 0L) {
            throw new ContractValidateException("percent not in [0, 100]");
        }
        byte[] contractAddress = contract.getContractAddress().toByteArray();
        ContractCapsule deployedContract = contractStore.get(contractAddress);
        if (deployedContract == null) {
            throw new ContractValidateException("Contract does not exist");
        }
        byte[] deployedContractOwnerAddress = deployedContract.getInstance().getOriginAddress().toByteArray();
        if (!Arrays.equals(ownerAddress, deployedContractOwnerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is not the owner of the contract");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((SmartContractOuterClass.UpdateSettingContract)this.any.unpack(SmartContractOuterClass.UpdateSettingContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

