/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.tron.core.vm.EnergyCost;
import org.tron.core.vm.JumpTable;
import org.tron.core.vm.Operation;
import org.tron.core.vm.OperationActions;
import org.tron.core.vm.config.VMConfig;

public class OperationRegistry {
    private static final Map<Version, JumpTable> tableMap = new HashMap<Version, JumpTable>();

    public static JumpTable newTronV10OperationSet() {
        JumpTable table = OperationRegistry.newBaseOperationSet();
        OperationRegistry.appendTransferTrc10Operations(table);
        OperationRegistry.appendConstantinopleOperations(table);
        OperationRegistry.appendSolidity059Operations(table);
        OperationRegistry.appendIstanbulOperations(table);
        OperationRegistry.appendFreezeOperations(table);
        OperationRegistry.appendVoteOperations(table);
        OperationRegistry.appendLondonOperations(table);
        return table;
    }

    public static JumpTable newTronV11OperationSet() {
        return OperationRegistry.newTronV10OperationSet();
    }

    public static JumpTable newTronV12OperationSet() {
        JumpTable table = OperationRegistry.newTronV11OperationSet();
        OperationRegistry.appendFreezeV2Operations(table);
        OperationRegistry.appendDelegateOperations(table);
        return table;
    }

    public static JumpTable newTronV13OperationSet() {
        JumpTable table = OperationRegistry.newTronV12OperationSet();
        OperationRegistry.appendShangHaiOperations(table);
        return table;
    }

    public static void init() {
    }

    public static JumpTable getTable() {
        JumpTable table = tableMap.get((Object)Version.TRON_V1_3);
        if (VMConfig.allowHigherLimitForMaxCpuTimeOfOneTx()) {
            OperationRegistry.adjustMemOperations(table);
        }
        return table;
    }

    public static JumpTable newBaseOperationSet() {
        int i;
        JumpTable table = new JumpTable();
        table.set(new Operation(0, 0, 0, EnergyCost::getZeroTierCost, OperationActions::stopAction));
        table.set(new Operation(1, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::addAction));
        table.set(new Operation(2, 2, 1, EnergyCost::getLowTierCost, OperationActions::mulAction));
        table.set(new Operation(3, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::subAction));
        table.set(new Operation(4, 2, 1, EnergyCost::getLowTierCost, OperationActions::divAction));
        table.set(new Operation(5, 2, 1, EnergyCost::getLowTierCost, OperationActions::sdivAction));
        table.set(new Operation(6, 2, 1, EnergyCost::getLowTierCost, OperationActions::modAction));
        table.set(new Operation(7, 2, 1, EnergyCost::getLowTierCost, OperationActions::sModAction));
        table.set(new Operation(8, 3, 1, EnergyCost::getMidTierCost, OperationActions::addModAction));
        table.set(new Operation(9, 3, 1, EnergyCost::getMidTierCost, OperationActions::mulModAction));
        table.set(new Operation(10, 2, 1, EnergyCost::getExpCost, OperationActions::expAction));
        table.set(new Operation(11, 2, 1, EnergyCost::getLowTierCost, OperationActions::signExtendAction));
        table.set(new Operation(16, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::ltAction));
        table.set(new Operation(17, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::gtAction));
        table.set(new Operation(18, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::sltAction));
        table.set(new Operation(19, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::sgtAction));
        table.set(new Operation(20, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::eqAction));
        table.set(new Operation(21, 1, 1, EnergyCost::getVeryLowTierCost, OperationActions::isZeroAction));
        table.set(new Operation(22, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::andAction));
        table.set(new Operation(23, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::orAction));
        table.set(new Operation(24, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::xorAction));
        table.set(new Operation(25, 1, 1, EnergyCost::getVeryLowTierCost, OperationActions::notAction));
        table.set(new Operation(26, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::byteAction));
        table.set(new Operation(32, 2, 1, EnergyCost::getSha3Cost, OperationActions::sha3Action));
        table.set(new Operation(48, 0, 1, EnergyCost::getBaseTierCost, OperationActions::addressAction));
        table.set(new Operation(49, 1, 1, EnergyCost::getBalanceCost, OperationActions::balanceAction));
        table.set(new Operation(50, 0, 1, EnergyCost::getBaseTierCost, OperationActions::originAction));
        table.set(new Operation(51, 0, 1, EnergyCost::getBaseTierCost, OperationActions::callerAction));
        table.set(new Operation(52, 0, 1, EnergyCost::getBaseTierCost, OperationActions::callValueAction));
        table.set(new Operation(53, 1, 1, EnergyCost::getVeryLowTierCost, OperationActions::callDataLoadAction));
        table.set(new Operation(54, 0, 1, EnergyCost::getBaseTierCost, OperationActions::callDataSizeAction));
        table.set(new Operation(55, 3, 0, EnergyCost::getCallDataCopyCost, OperationActions::callDataCopyAction));
        table.set(new Operation(56, 0, 1, EnergyCost::getBaseTierCost, OperationActions::codeSizeAction));
        table.set(new Operation(57, 3, 0, EnergyCost::getCodeCopyCost, OperationActions::codeCopyAction));
        table.set(new Operation(61, 0, 1, EnergyCost::getBaseTierCost, OperationActions::returnDataSizeAction));
        table.set(new Operation(62, 3, 0, EnergyCost::getReturnDataCopyCost, OperationActions::returnDataCopyAction));
        table.set(new Operation(58, 0, 1, EnergyCost::getBaseTierCost, OperationActions::gasPriceAction));
        table.set(new Operation(59, 1, 1, EnergyCost::getExtCodeSizeCost, OperationActions::extCodeSizeAction));
        table.set(new Operation(60, 4, 0, EnergyCost::getExtCodeCopyCost, OperationActions::extCodeCopyAction));
        table.set(new Operation(64, 1, 1, EnergyCost::getExtTierCost, OperationActions::blockHashAction));
        table.set(new Operation(65, 0, 1, EnergyCost::getBaseTierCost, OperationActions::coinBaseAction));
        table.set(new Operation(66, 0, 1, EnergyCost::getBaseTierCost, OperationActions::timeStampAction));
        table.set(new Operation(67, 0, 1, EnergyCost::getBaseTierCost, OperationActions::numberAction));
        table.set(new Operation(68, 0, 1, EnergyCost::getBaseTierCost, OperationActions::difficultyAction));
        table.set(new Operation(69, 0, 1, EnergyCost::getBaseTierCost, OperationActions::gasLimitAction));
        table.set(new Operation(80, 1, 0, EnergyCost::getBaseTierCost, OperationActions::popAction));
        table.set(new Operation(81, 1, 1, EnergyCost::getMloadCost, OperationActions::mLoadAction));
        table.set(new Operation(82, 2, 0, EnergyCost::getMStoreCost, OperationActions::mStoreAction));
        table.set(new Operation(83, 2, 0, EnergyCost::getMStore8Cost, OperationActions::mStore8Action));
        table.set(new Operation(84, 1, 1, EnergyCost::getSloadCost, OperationActions::sLoadAction));
        table.set(new Operation(85, 2, 0, EnergyCost::getSstoreCost, OperationActions::sStoreAction));
        table.set(new Operation(86, 1, 0, EnergyCost::getMidTierCost, OperationActions::jumpAction));
        table.set(new Operation(87, 2, 0, EnergyCost::getHighTierCost, OperationActions::jumpIAction));
        table.set(new Operation(88, 0, 1, EnergyCost::getBaseTierCost, OperationActions::pcAction));
        table.set(new Operation(89, 0, 1, EnergyCost::getBaseTierCost, OperationActions::mSizeAction));
        table.set(new Operation(90, 0, 1, EnergyCost::getBaseTierCost, OperationActions::gasAction));
        table.set(new Operation(91, 0, 0, EnergyCost::getSpecialTierCost, OperationActions::jumpDestAction));
        for (i = 0; i < 32; ++i) {
            table.set(new Operation(96 + i, 0, 1, EnergyCost::getVeryLowTierCost, OperationActions::pushAction));
        }
        for (i = 0; i < 16; ++i) {
            table.set(new Operation(128 + i, 1 + i, 2 + i, EnergyCost::getVeryLowTierCost, OperationActions::dupAction));
        }
        for (i = 0; i < 16; ++i) {
            table.set(new Operation(144 + i, 2 + i, 2 + i, EnergyCost::getVeryLowTierCost, OperationActions::swapAction));
        }
        for (i = 0; i <= 4; ++i) {
            table.set(new Operation(160 + i, 2 + i, 0, EnergyCost::getLogCost, OperationActions::logAction));
        }
        table.set(new Operation(240, 3, 1, EnergyCost::getCreateCost, OperationActions::createAction));
        table.set(new Operation(241, 7, 1, EnergyCost::getCallCost, OperationActions::callAction));
        table.set(new Operation(242, 7, 1, EnergyCost::getCallCodeCost, OperationActions::callCodeAction));
        table.set(new Operation(243, 2, 0, EnergyCost::getReturnCost, OperationActions::returnAction));
        table.set(new Operation(244, 6, 1, EnergyCost::getDelegateCallCost, OperationActions::delegateCallAction));
        table.set(new Operation(250, 6, 1, EnergyCost::getStaticCallCost, OperationActions::staticCallAction));
        table.set(new Operation(253, 2, 0, EnergyCost::getRevertCost, OperationActions::revertAction));
        table.set(new Operation(255, 1, 0, EnergyCost::getSuicideCost, OperationActions::suicideAction));
        return table;
    }

    public static void appendTransferTrc10Operations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmTransferTrc10;
        table.set(new Operation(208, 8, 1, EnergyCost::getCallTokenCost, OperationActions::callTokenAction, proposal));
        table.set(new Operation(209, 2, 1, EnergyCost::getBalanceCost, OperationActions::tokenBalanceAction, proposal));
        table.set(new Operation(210, 0, 1, EnergyCost::getBaseTierCost, OperationActions::callTokenValueAction, proposal));
        table.set(new Operation(211, 0, 1, EnergyCost::getBaseTierCost, OperationActions::callTokenIdAction, proposal));
    }

    public static void appendConstantinopleOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmConstantinople;
        table.set(new Operation(27, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::shlAction, proposal));
        table.set(new Operation(28, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::shrAction, proposal));
        table.set(new Operation(29, 2, 1, EnergyCost::getVeryLowTierCost, OperationActions::sarAction, proposal));
        table.set(new Operation(245, 4, 1, EnergyCost::getCreate2Cost, OperationActions::create2Action, proposal));
        table.set(new Operation(63, 1, 1, EnergyCost::getExtCodeHashCost, OperationActions::extCodeHashAction, proposal));
    }

    public static void appendSolidity059Operations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmSolidity059;
        table.set(new Operation(212, 1, 1, EnergyCost::getBalanceCost, OperationActions::isContractAction, proposal));
    }

    public static void appendIstanbulOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmIstanbul;
        table.set(new Operation(70, 0, 1, EnergyCost::getBaseTierCost, OperationActions::chainIdAction, proposal));
        table.set(new Operation(71, 0, 1, EnergyCost::getLowTierCost, OperationActions::selfBalanceAction, proposal));
    }

    public static void appendFreezeOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmFreeze;
        table.set(new Operation(213, 3, 1, EnergyCost::getFreezeCost, OperationActions::freezeAction, proposal));
        table.set(new Operation(214, 2, 1, EnergyCost::getUnfreezeCost, OperationActions::unfreezeAction, proposal));
        table.set(new Operation(215, 2, 1, EnergyCost::getFreezeExpireTimeCost, OperationActions::freezeExpireTimeAction, proposal));
    }

    public static void appendVoteOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmVote;
        table.set(new Operation(216, 4, 1, EnergyCost::getVoteWitnessCost, OperationActions::voteWitnessAction, proposal));
        table.set(new Operation(217, 0, 1, EnergyCost::getWithdrawRewardCost, OperationActions::withdrawRewardAction, proposal));
    }

    public static void appendLondonOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmLondon;
        table.set(new Operation(72, 0, 1, EnergyCost::getBaseTierCost, OperationActions::baseFeeAction, proposal));
    }

    public static void adjustMemOperations(JumpTable table) {
        table.set(new Operation(81, 1, 1, EnergyCost::getMloadCost2, OperationActions::mLoadAction));
        table.set(new Operation(82, 2, 0, EnergyCost::getMStoreCost2, OperationActions::mStoreAction));
        table.set(new Operation(83, 2, 0, EnergyCost::getMStore8Cost2, OperationActions::mStore8Action));
    }

    public static void appendFreezeV2Operations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmFreezeV2;
        table.set(new Operation(218, 2, 1, EnergyCost::getFreezeBalanceV2Cost, OperationActions::freezeBalanceV2Action, proposal));
        table.set(new Operation(219, 2, 1, EnergyCost::getUnfreezeBalanceV2Cost, OperationActions::unfreezeBalanceV2Action, proposal));
        table.set(new Operation(221, 0, 1, EnergyCost::getWithdrawExpireUnfreezeCost, OperationActions::withdrawExpireUnfreezeAction, proposal));
        table.set(new Operation(220, 0, 1, EnergyCost::getCancelAllUnfreezeV2Cost, OperationActions::cancelAllUnfreezeV2Action, proposal));
    }

    public static void appendDelegateOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmFreezeV2;
        table.set(new Operation(222, 3, 1, EnergyCost::getDelegateResourceCost, OperationActions::delegateResourceAction, proposal));
        table.set(new Operation(223, 3, 1, EnergyCost::getUnDelegateResourceCost, OperationActions::unDelegateResourceAction, proposal));
    }

    public static void appendShangHaiOperations(JumpTable table) {
        BooleanSupplier proposal = VMConfig::allowTvmShanghai;
        table.set(new Operation(95, 0, 1, EnergyCost::getBaseTierCost, OperationActions::push0Action, proposal));
    }

    static {
        tableMap.put(Version.TRON_V1_0, OperationRegistry.newTronV10OperationSet());
        tableMap.put(Version.TRON_V1_1, OperationRegistry.newTronV11OperationSet());
        tableMap.put(Version.TRON_V1_2, OperationRegistry.newTronV12OperationSet());
        tableMap.put(Version.TRON_V1_3, OperationRegistry.newTronV13OperationSet());
    }

    public static enum Version {
        TRON_V1_0,
        TRON_V1_1,
        TRON_V1_2,
        TRON_V1_3;

    }
}

